/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.aspose.exports.slide;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import net.xmind.verify.ui.VerifyUI20141031;
import net.xmind.verify.ui.VerifyWizardPage20141031;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.ui.internal.aspose.AsposePlugin;
import org.xmind.ui.internal.aspose.exports.ExportMessages;
import org.xmind.ui.internal.aspose.exports.IExportAvailabilityChecker;
import org.xmind.ui.internal.aspose.exports.slide.PPTExportPageBase;
import org.xmind.ui.internal.aspose.exports.slide.PPTExporter;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.wizards.DocumentExportWizard;
import org.xmind.ui.wizards.IExporter;

public class ODPExportWizard
extends DocumentExportWizard
implements IExportAvailabilityChecker {
    private static final String PAGE_NAME = "org.xmind.ui.export.odpExportPage";
    private static final String SECTION_NAME = "org.xmind.ui.export.odp";
    private static final String FILE_EXT = ".odp";
    private ODPExportPage page;

    public ODPExportWizard() {
        this.setWindowTitle(ExportMessages.ODPWizard_WindowTitle);
        this.setDialogSettings(AsposePlugin.getDialogSettings(SECTION_NAME));
        this.setDefaultPageImageDescriptor(MindMapUI.getImages().getWizBan("export_wiz.png"));
    }

    public boolean checkAvailability() {
        return true;
    }

    protected IExporter createExporter() {
        IMindMap mindmap = this.getSourceMindMap();
        ITopic centralTopic = mindmap.getCentralTopic();
        ISheet sheet = mindmap.getSheet();
        PPTExporter exporter = new PPTExporter(sheet, centralTopic, this.getTargetPath(), 3);
        exporter.setDialogSettings(this.getDialogSettings());
        exporter.init();
        return exporter;
    }

    protected void addValidPages() {
        this.addPage((IWizardPage)new VerifyWizardPage20141031("ExportToODP", ExportMessages.ODPExportJob_Name));
        this.page = new ODPExportPage();
        this.addPage((IWizardPage)this.page);
    }

    protected String getFormatName() {
        return ExportMessages.ODPWizard_FormatName;
    }

    protected boolean isExtensionCompatible(String path, String extension) {
        return super.isExtensionCompatible(path, extension) && FILE_EXT.equalsIgnoreCase(extension);
    }

    protected void handleExportException(Throwable e) {
        super.handleExportException(e);
        this.page.setErrorMessage(e.getLocalizedMessage());
    }

    protected String getSuggestedFileName() {
        return String.valueOf(super.getSuggestedFileName()) + FILE_EXT;
    }

    protected void doExport(IProgressMonitor monitor, Display display, Shell parentShell) throws InvocationTargetException, InterruptedException {
        VerifyUI20141031.getUsageDataCollector().increase("ExportToODPCount");
        super.doExport(monitor, display, parentShell);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ODPExportPage
    extends PPTExportPageBase {
        public ODPExportPage() {
            super(ODPExportWizard.PAGE_NAME, ExportMessages.ODPPage_Title);
            this.setDescription(ExportMessages.ODPPage_Description);
        }

        protected void setDialogFilters(FileDialog dialog, List<String> filterNames, List<String> filterExtensions) {
            filterNames.add(0, ExportMessages.ODPPage_FilterName);
            filterExtensions.add(0, "*.odp");
            super.setDialogFilters(dialog, filterNames, filterExtensions);
        }
    }
}

