/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.actions;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.actions.ActionFactory;

public class DelegatingAction
extends Action
implements ActionFactory.IWorkbenchAction,
IPropertyChangeListener {
    private IAction delegate;
    private List<String> properties;

    public DelegatingAction(IAction delegate) {
        this(delegate, "text", "image", "toolTipText", "description", "checked", "enabled");
    }

    public DelegatingAction(IAction delegate, String ... properties) {
        this(delegate, delegate.getStyle(), properties);
    }

    public DelegatingAction(IAction delegate, int style, String ... properties) {
        super(delegate.getText(), style);
        this.delegate = delegate;
        this.properties = Arrays.asList(properties);
        this.setId(delegate.getId());
        this.setActionDefinitionId(delegate.getActionDefinitionId());
        this.initProperties(delegate);
        delegate.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    private void initProperties(IAction delegate) {
        if (this.properties.contains("text")) {
            this.setText(delegate.getText());
            this.setAccelerator(delegate.getAccelerator());
        }
        if (this.properties.contains("toolTipText")) {
            this.setToolTipText(delegate.getToolTipText());
        }
        if (this.properties.contains("image")) {
            this.setImageDescriptor(delegate.getImageDescriptor());
            this.setDisabledImageDescriptor(delegate.getDisabledImageDescriptor());
            this.setHoverImageDescriptor(delegate.getHoverImageDescriptor());
        }
        if (this.properties.contains("enabled")) {
            this.setEnabled(delegate.isEnabled());
        }
        if (this.properties.contains("checked") && (delegate.getStyle() == 2 || delegate.getStyle() == 8)) {
            this.setChecked(delegate.isChecked());
        }
        if (this.properties.contains("description")) {
            this.setDescription(delegate.getDescription());
        }
    }

    public void run() {
        this.delegate.run();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.needUpdate("text", event)) {
            this.setText(this.delegate.getText());
            this.setAccelerator(this.delegate.getAccelerator());
        } else if (this.needUpdate("toolTipText", event)) {
            this.setToolTipText(this.delegate.getToolTipText());
        } else if (this.needUpdate("description", event)) {
            this.setDescription(this.delegate.getDescription());
        } else if (this.needUpdate("image", event)) {
            this.setImageDescriptor(this.delegate.getImageDescriptor());
            this.setDisabledImageDescriptor(this.delegate.getDisabledImageDescriptor());
            this.setHoverImageDescriptor(this.delegate.getHoverImageDescriptor());
        } else if (this.needUpdate("enabled", event)) {
            this.setEnabled(this.delegate.isEnabled());
        } else if (this.needUpdate("checked", event)) {
            this.setChecked(this.delegate.isChecked());
        }
    }

    private boolean needUpdate(String property, PropertyChangeEvent event) {
        return property.equals(event.getProperty()) && this.properties.contains(property);
    }

    public void dispose() {
        this.delegate.removePropertyChangeListener((IPropertyChangeListener)this);
    }
}

