/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.actions;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.ui.actions.ISelectionAction;
import org.xmind.gef.ui.actions.PageAction;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.actions.MindMapActionFactory;
import org.xmind.ui.internal.dialogs.HyperlinkDialog;
import org.xmind.ui.util.MindMapUtils;

public class ModifyHyperlinkAction
extends PageAction
implements ISelectionAction {
    public ModifyHyperlinkAction(IGraphicalEditorPage page) {
        super(MindMapActionFactory.MODIFY_HYPERLINK.getId(), page);
    }

    public void run() {
        if (this.isDisposed()) {
            return;
        }
        Shell parentShell = this.getEditor().getSite().getShell();
        ISelection selection = this.getPage().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection) {
            HyperlinkDialog dialog = new HyperlinkDialog(parentShell, (IEditorPart)this.getEditor(), (IStructuredSelection)selection);
            int retCode = dialog.open();
            if (retCode == 0) {
                this.modifyHyperlink(dialog.getValue());
            } else if (retCode == 3) {
                this.modifyHyperlink(null);
            }
        }
    }

    private void modifyHyperlink(String newHyperlink) {
        this.sendRequest(new Request("modify_hyperlink").setParameter("text", (Object)newHyperlink));
    }

    public void setSelection(ISelection selection) {
        this.setEnabled(MindMapUtils.isPropertyModifiable(selection, "topicHyperlink", (IViewer)this.getViewer()));
    }
}

