/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.oracle;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.query.BatchQueryRow;

class Oracle8LOBBatchQueryWrapper {
    protected BatchQuery query;
    protected List<DbAttribute> dbAttributes;
    protected boolean[] qualifierAttributes;
    protected boolean[] allLOBAttributes;
    protected Object[] updatedLOBAttributes;

    Oracle8LOBBatchQueryWrapper(BatchQuery query) {
        this.query = query;
        this.dbAttributes = query.getDbAttributes();
        int len = this.dbAttributes.size();
        this.qualifierAttributes = new boolean[len];
        this.allLOBAttributes = new boolean[len];
        this.updatedLOBAttributes = new Object[len];
        this.indexQualifierAttributes();
    }

    protected void indexQualifierAttributes() {
        int len = this.dbAttributes.size();
        for (int i = 0; i < len; ++i) {
            DbAttribute attribute = this.dbAttributes.get(i);
            int type = attribute.getType();
            this.qualifierAttributes[i] = attribute.isPrimaryKey();
            this.allLOBAttributes[i] = type == 2004 || type == 2005;
        }
    }

    void indexLOBAttributes(BatchQueryRow row) {
        int len = this.updatedLOBAttributes.length;
        for (int i = 0; i < len; ++i) {
            Object value;
            this.updatedLOBAttributes[i] = null;
            if (!this.allLOBAttributes[i] || (value = row.getValue(i)) == null) continue;
            this.updatedLOBAttributes[i] = this.dbAttributes.get(i).getType() == 2004 ? (Object)this.convertToBlobValue(value) : this.convertToClobValue(value);
        }
    }

    protected byte[] convertToBlobValue(Object value) {
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            return bytes.length == 0 ? null : bytes;
        }
        if (value instanceof Serializable) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream(){

                @Override
                public synchronized byte[] toByteArray() {
                    return this.buf;
                }
            };
            try (ObjectOutputStream out = new ObjectOutputStream(bytes);){
                out.writeObject(value);
            }
            catch (IOException e) {
                throw new CayenneRuntimeException("Error serializing object", (Throwable)e, new Object[0]);
            }
            return bytes.toByteArray();
        }
        return null;
    }

    protected Object convertToClobValue(Object value) {
        if (value instanceof char[]) {
            char[] chars = (char[])value;
            return chars.length == 0 ? null : chars;
        }
        String strValue = value.toString();
        return strValue.length() == 0 ? null : strValue;
    }

    List<DbAttribute> getDbAttributesForLOBSelectQualifier() {
        int len = this.qualifierAttributes.length;
        ArrayList<DbAttribute> attributes = new ArrayList<DbAttribute>(len);
        for (int i = 0; i < len; ++i) {
            if (!this.qualifierAttributes[i]) continue;
            attributes.add(this.dbAttributes.get(i));
        }
        return attributes;
    }

    List<DbAttribute> getDbAttributesForUpdatedLOBColumns() {
        int len = this.updatedLOBAttributes.length;
        ArrayList<DbAttribute> attributes = new ArrayList<DbAttribute>(len);
        for (int i = 0; i < len; ++i) {
            if (this.updatedLOBAttributes[i] == null) continue;
            attributes.add(this.dbAttributes.get(i));
        }
        return attributes;
    }

    List<Object> getValuesForLOBSelectQualifier(BatchQueryRow row) {
        int len = this.qualifierAttributes.length;
        ArrayList<Object> values = new ArrayList<Object>(len);
        for (int i = 0; i < len; ++i) {
            if (!this.qualifierAttributes[i]) continue;
            values.add(row.getValue(i));
        }
        return values;
    }

    List<Object> getValuesForUpdatedLOBColumns() {
        int len = this.updatedLOBAttributes.length;
        ArrayList<Object> values = new ArrayList<Object>(len);
        for (Object updatedLOBAttribute : this.updatedLOBAttributes) {
            if (updatedLOBAttribute == null) continue;
            values.add(updatedLOBAttribute);
        }
        return values;
    }
}

