/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.input.ChecksumInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class IOUtilsConcurrentTest {
    private static final byte[][] BYTE_DATA;
    private static final long[] BYTE_DATA_CHECKSUM;
    private static final int RUNS_PER_THREAD = 16;
    private static final int SIZE = 8192;
    private static final String[] STRING_DATA;
    private static final long[] STRING_DATA_CHECKSUM;
    private static final int THREAD_COUNT = 16;
    private static final int VARIANTS = 16;

    IOUtilsConcurrentTest() {
    }

    static Stream<IOConsumer<InputStream>> testConcurrentInputStreamTasks() {
        return Stream.of(IOUtils::consume, in -> IOUtils.skip((InputStream)in, (long)Long.MAX_VALUE), in -> IOUtils.skipFully((InputStream)in, (long)8192L), IOUtils::toByteArray, in -> IOUtils.toByteArray((InputStream)in, (int)8192), in -> IOUtils.toByteArray((InputStream)in, (int)8192, (int)512));
    }

    static Stream<IOConsumer<Reader>> testConcurrentReaderTasks() {
        return Stream.of(IOUtils::consume, reader -> IOUtils.skip((Reader)reader, (long)Long.MAX_VALUE), reader -> IOUtils.skipFully((Reader)reader, (long)8192L), reader -> IOUtils.toByteArray((Reader)reader, (Charset)Charset.defaultCharset()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource
    void testConcurrentInputStreamTasks(IOConsumer<InputStream> consumer) throws InterruptedException {
        ExecutorService threadPool = Executors.newFixedThreadPool(16);
        try {
            List<Future> futures = IntStream.range(0, 256).mapToObj(i -> threadPool.submit(() -> {
                try (ChecksumInputStream in = ((ChecksumInputStream.Builder)ChecksumInputStream.builder().setByteArray(BYTE_DATA[i % 16])).setChecksum((Checksum)new CRC32()).setExpectedChecksumValue(BYTE_DATA_CHECKSUM[i % 16]).get();){
                    consumer.accept((Object)in);
                }
                return null;
            })).collect(Collectors.toList());
            futures.forEach(f -> Assertions.assertDoesNotThrow(() -> (Void)f.get()));
        }
        finally {
            threadPool.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource
    void testConcurrentReaderTasks(IOConsumer<Reader> consumer) throws InterruptedException {
        ExecutorService threadPool = Executors.newFixedThreadPool(16);
        try {
            List<Future> futures = IntStream.range(0, 256).mapToObj(i -> threadPool.submit(() -> {
                try (ChecksumReader reader = new ChecksumReader(new StringReader(STRING_DATA[i % 16]), STRING_DATA_CHECKSUM[i % 16]);){
                    consumer.accept((Object)reader);
                }
                return null;
            })).collect(Collectors.toList());
            futures.forEach(f -> Assertions.assertDoesNotThrow(() -> (Void)f.get()));
        }
        finally {
            threadPool.shutdownNow();
        }
    }

    static {
        CRC32 checksum = new CRC32();
        BYTE_DATA = new byte[16][];
        BYTE_DATA_CHECKSUM = new long[16];
        for (int variant = 0; variant < 16; ++variant) {
            byte[] data = new byte[8192];
            for (int i = 0; i < 8192; ++i) {
                data[i] = (byte)((i + variant) % 256);
            }
            IOUtilsConcurrentTest.BYTE_DATA[variant] = data;
            checksum.reset();
            checksum.update(data, 0, data.length);
            IOUtilsConcurrentTest.BYTE_DATA_CHECKSUM[variant] = checksum.getValue();
        }
        char[] cdata = new char[8192];
        STRING_DATA = new String[16];
        STRING_DATA_CHECKSUM = new long[16];
        for (int variant = 0; variant < 16; ++variant) {
            for (int i = 0; i < 8192; ++i) {
                cdata[i] = (char)((i + variant) % 65535);
            }
            IOUtilsConcurrentTest.STRING_DATA[variant] = new String(cdata);
            checksum.reset();
            byte[] bytes = STRING_DATA[variant].getBytes(Charset.defaultCharset());
            checksum.update(bytes, 0, bytes.length);
            IOUtilsConcurrentTest.STRING_DATA_CHECKSUM[variant] = checksum.getValue();
        }
    }

    private static class ChecksumReader
    extends Reader {
        private final CRC32 checksum;
        private final long expectedChecksumValue;
        private final Reader reader;

        ChecksumReader(Reader reader, long expectedChecksumValue) {
            this.reader = reader;
            this.checksum = new CRC32();
            this.expectedChecksumValue = expectedChecksumValue;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }

        public long getValue() {
            return this.checksum.getValue();
        }

        @Override
        public int read() throws IOException {
            return super.read();
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            long actual;
            int n = this.reader.read(cbuf, off, len);
            if (n > 0) {
                byte[] bytes = new String(cbuf, off, n).getBytes(Charset.defaultCharset());
                this.checksum.update(bytes, 0, bytes.length);
            }
            if (n == -1 && (actual = this.checksum.getValue()) != this.expectedChecksumValue) {
                throw new IOException("Checksum mismatch: expected " + this.expectedChecksumValue + " but got " + actual);
            }
            return n;
        }
    }
}

