/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.math.BigDecimal;
import java.util.Locale;
import org.apache.commons.validator.routines.BigDecimalValidator;
import org.apache.commons.validator.routines.PercentValidator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.DefaultLocale;

class PercentValidatorTest {
    protected PercentValidator validator;
    private Locale originalLocale;

    PercentValidatorTest() {
    }

    @BeforeEach
    protected void setUp() {
        this.originalLocale = Locale.getDefault();
        this.validator = new PercentValidator();
    }

    @AfterEach
    protected void tearDown() {
        Locale.setDefault(this.originalLocale);
        this.validator = null;
    }

    @Test
    void testFormatType() {
        Assertions.assertEquals((int)2, (int)PercentValidator.getInstance().getFormatType(), (String)"Format Type A");
        Assertions.assertEquals((int)2, (int)PercentValidator.getInstance().getFormatType(), (String)"Format Type B");
    }

    @Test
    void testInvalid() {
        BigDecimalValidator validator = PercentValidator.getInstance();
        Assertions.assertFalse((boolean)validator.isValid(null), (String)"isValid() Null Value");
        Assertions.assertFalse((boolean)validator.isValid(""), (String)"isValid() Empty Value");
        Assertions.assertNull((Object)validator.validate(null), (String)"validate() Null Value");
        Assertions.assertNull((Object)validator.validate(""), (String)"validate() Empty Value");
        Assertions.assertFalse((boolean)validator.isValid("12@", Locale.UK), (String)"UK wrong symbol");
        Assertions.assertFalse((boolean)validator.isValid("(12%)", Locale.UK), (String)"UK wrong negative");
        Assertions.assertFalse((boolean)validator.isValid("12@", Locale.US), (String)"US wrong symbol");
        Assertions.assertFalse((boolean)validator.isValid("(12%)", Locale.US), (String)"US wrong negative");
    }

    @Test
    @DefaultLocale(value="en-GB")
    void testValid() {
        BigDecimalValidator validator = PercentValidator.getInstance();
        BigDecimal expected = new BigDecimal("0.12");
        BigDecimal negative = new BigDecimal("-0.12");
        BigDecimal hundred = new BigDecimal("1.00");
        Assertions.assertEquals((Object)expected, (Object)validator.validate("12%"), (String)"Default locale");
        Assertions.assertEquals((Object)negative, (Object)validator.validate("-12%"), (String)"Default negative");
        Assertions.assertEquals((Object)expected, (Object)validator.validate("12%", Locale.UK), (String)"UK locale");
        Assertions.assertEquals((Object)negative, (Object)validator.validate("-12%", Locale.UK), (String)"UK negative");
        Assertions.assertEquals((Object)expected, (Object)validator.validate("12", Locale.UK), (String)"UK No symbol");
        Assertions.assertEquals((Object)expected, (Object)validator.validate("12%", Locale.US), (String)"US locale");
        Assertions.assertEquals((Object)negative, (Object)validator.validate("-12%", Locale.US), (String)"US negative");
        Assertions.assertEquals((Object)expected, (Object)validator.validate("12", Locale.US), (String)"US No symbol");
        Assertions.assertEquals((Object)hundred, (Object)validator.validate("100%"), (String)"100%");
    }
}

