/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.nio;

import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.EndpointInfo;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.client5.http.impl.ConnPoolSupport;
import org.apache.hc.client5.http.impl.ConnectionHolder;
import org.apache.hc.client5.http.impl.ConnectionShutdownException;
import org.apache.hc.client5.http.impl.PrefixedIncrementingId;
import org.apache.hc.client5.http.impl.nio.DefaultAsyncClientConnectionOperator;
import org.apache.hc.client5.http.impl.nio.H2SharingConnPool;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.nio.AsyncClientConnectionOperator;
import org.apache.hc.client5.http.nio.AsyncConnectionEndpoint;
import org.apache.hc.client5.http.nio.ManagedAsyncClientConnection;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.BasicFuture;
import org.apache.hc.core5.concurrent.CallbackContribution;
import org.apache.hc.core5.concurrent.ComplexFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Resolver;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.command.RequestExecutionCommand;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.http2.nio.command.PingCommand;
import org.apache.hc.core5.http2.nio.support.BasicPingHandler;
import org.apache.hc.core5.http2.ssl.ApplicationProtocol;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.pool.ConnPoolControl;
import org.apache.hc.core5.pool.DefaultDisposalCallback;
import org.apache.hc.core5.pool.LaxConnPool;
import org.apache.hc.core5.pool.ManagedConnPool;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolEntry;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.pool.PoolStats;
import org.apache.hc.core5.pool.StrictConnPool;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.ConnectionInitiator;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Deadline;
import org.apache.hc.core5.util.Identifiable;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class PoolingAsyncClientConnectionManager
implements AsyncClientConnectionManager,
ConnPoolControl<HttpRoute> {
    private static final Logger LOG = LoggerFactory.getLogger(PoolingAsyncClientConnectionManager.class);
    public static final int DEFAULT_MAX_TOTAL_CONNECTIONS = 25;
    public static final int DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 5;
    private final ManagedConnPool<HttpRoute, ManagedAsyncClientConnection> pool;
    private final AsyncClientConnectionOperator connectionOperator;
    private final AtomicBoolean closed;
    private volatile Resolver<HttpRoute, ConnectionConfig> connectionConfigResolver;
    private volatile Resolver<HttpHost, TlsConfig> tlsConfigResolver;
    private static final PrefixedIncrementingId INCREMENTING_ID = new PrefixedIncrementingId("ep-");

    public PoolingAsyncClientConnectionManager() {
        this(RegistryBuilder.create().register(URIScheme.HTTPS.getId(), DefaultClientTlsStrategy.createDefault()).build());
    }

    public PoolingAsyncClientConnectionManager(Lookup<TlsStrategy> tlsStrategyLookup) {
        this(tlsStrategyLookup, PoolConcurrencyPolicy.STRICT, TimeValue.NEG_ONE_MILLISECOND);
    }

    public PoolingAsyncClientConnectionManager(Lookup<TlsStrategy> tlsStrategyLookup, PoolConcurrencyPolicy poolConcurrencyPolicy, TimeValue timeToLive) {
        this(tlsStrategyLookup, poolConcurrencyPolicy, PoolReusePolicy.LIFO, timeToLive);
    }

    public PoolingAsyncClientConnectionManager(Lookup<TlsStrategy> tlsStrategyLookup, PoolConcurrencyPolicy poolConcurrencyPolicy, PoolReusePolicy poolReusePolicy, TimeValue timeToLive) {
        this(tlsStrategyLookup, poolConcurrencyPolicy, poolReusePolicy, timeToLive, null, null);
    }

    public PoolingAsyncClientConnectionManager(Lookup<TlsStrategy> tlsStrategyLookup, PoolConcurrencyPolicy poolConcurrencyPolicy, PoolReusePolicy poolReusePolicy, TimeValue timeToLive, SchemePortResolver schemePortResolver, DnsResolver dnsResolver) {
        this(new DefaultAsyncClientConnectionOperator(tlsStrategyLookup, schemePortResolver, dnsResolver), poolConcurrencyPolicy, poolReusePolicy, timeToLive, false);
    }

    @Internal
    public PoolingAsyncClientConnectionManager(AsyncClientConnectionOperator connectionOperator, PoolConcurrencyPolicy poolConcurrencyPolicy, PoolReusePolicy poolReusePolicy, TimeValue timeToLive, boolean messageMultiplexing) {
        ManagedConnPool<HttpRoute, ManagedAsyncClientConnection> managedConnPool;
        this.connectionOperator = Args.notNull(connectionOperator, "Connection operator");
        switch (poolConcurrencyPolicy != null ? poolConcurrencyPolicy : PoolConcurrencyPolicy.STRICT) {
            case STRICT: {
                managedConnPool = new StrictConnPool<HttpRoute, ManagedAsyncClientConnection>(5, 25, timeToLive, poolReusePolicy, new DefaultDisposalCallback(), null){

                    @Override
                    public void closeExpired() {
                        this.enumAvailable(e -> PoolingAsyncClientConnectionManager.this.closeIfExpired((PoolEntry<HttpRoute, ManagedAsyncClientConnection>)e));
                    }
                };
                break;
            }
            case LAX: {
                managedConnPool = new LaxConnPool<HttpRoute, ManagedAsyncClientConnection>(5, timeToLive, poolReusePolicy, null){

                    @Override
                    public void closeExpired() {
                        this.enumAvailable(e -> PoolingAsyncClientConnectionManager.this.closeIfExpired((PoolEntry<HttpRoute, ManagedAsyncClientConnection>)e));
                    }
                };
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected PoolConcurrencyPolicy value: " + (Object)((Object)poolConcurrencyPolicy));
            }
        }
        this.pool = messageMultiplexing ? new H2SharingConnPool<HttpRoute, ManagedAsyncClientConnection>(managedConnPool) : managedConnPool;
        this.closed = new AtomicBoolean(false);
    }

    @Internal
    protected PoolingAsyncClientConnectionManager(ManagedConnPool<HttpRoute, ManagedAsyncClientConnection> pool, AsyncClientConnectionOperator connectionOperator) {
        this.connectionOperator = Args.notNull(connectionOperator, "Connection operator");
        this.pool = Args.notNull(pool, "Connection pool");
        this.closed = new AtomicBoolean(false);
    }

    @Override
    public void close() {
        this.close(CloseMode.GRACEFUL);
    }

    @Override
    public void close(CloseMode closeMode) {
        if (this.closed.compareAndSet(false, true)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Shutdown connection pool {}", (Object)closeMode);
            }
            this.pool.close(closeMode);
            LOG.debug("Connection pool shut down");
        }
    }

    private InternalConnectionEndpoint cast(AsyncConnectionEndpoint endpoint) {
        if (endpoint instanceof InternalConnectionEndpoint) {
            return (InternalConnectionEndpoint)endpoint;
        }
        throw new IllegalStateException("Unexpected endpoint class: " + endpoint.getClass());
    }

    private ConnectionConfig resolveConnectionConfig(HttpRoute route) {
        Resolver<HttpRoute, ConnectionConfig> resolver = this.connectionConfigResolver;
        ConnectionConfig connectionConfig = resolver != null ? resolver.resolve(route) : null;
        return connectionConfig != null ? connectionConfig : ConnectionConfig.DEFAULT;
    }

    private TlsConfig resolveTlsConfig(HttpHost host) {
        TlsConfig tlsConfig;
        Resolver<HttpHost, TlsConfig> resolver = this.tlsConfigResolver;
        TlsConfig tlsConfig2 = tlsConfig = resolver != null ? resolver.resolve(host) : null;
        if (tlsConfig == null) {
            tlsConfig = TlsConfig.DEFAULT;
        }
        if (URIScheme.HTTP.same(host.getSchemeName()) && tlsConfig.getHttpVersionPolicy() == HttpVersionPolicy.NEGOTIATE) {
            tlsConfig = TlsConfig.copy(tlsConfig).setVersionPolicy(HttpVersionPolicy.FORCE_HTTP_1).build();
        }
        return tlsConfig;
    }

    @Override
    public Future<AsyncConnectionEndpoint> lease(final String id, final HttpRoute route, final Object state, final Timeout requestTimeout, final FutureCallback<AsyncConnectionEndpoint> callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} endpoint lease request ({}) {}", id, requestTimeout, ConnPoolSupport.formatStats(route, state, this.pool));
        }
        return new Future<AsyncConnectionEndpoint>(){
            final ConnectionConfig connectionConfig;
            final BasicFuture<AsyncConnectionEndpoint> resultFuture;
            final Future<PoolEntry<HttpRoute, ManagedAsyncClientConnection>> leaseFuture;
            {
                this.connectionConfig = PoolingAsyncClientConnectionManager.this.resolveConnectionConfig(route);
                this.resultFuture = new BasicFuture(callback);
                this.leaseFuture = PoolingAsyncClientConnectionManager.this.pool.lease(route, state, requestTimeout, new FutureCallback<PoolEntry<HttpRoute, ManagedAsyncClientConnection>>(){

                    @Override
                    public void completed(PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry) {
                        TimeValue timeToLive;
                        if (poolEntry.hasConnection() && TimeValue.isNonNegative(timeToLive = connectionConfig.getTimeToLive()) && (timeToLive.getDuration() == 0L || Deadline.calculate(poolEntry.getCreated(), timeToLive).isExpired())) {
                            poolEntry.discardConnection(CloseMode.GRACEFUL);
                        }
                        if (poolEntry.hasConnection()) {
                            ProtocolVersion protocolVersion;
                            ManagedAsyncClientConnection connection = poolEntry.getConnection();
                            TimeValue timeValue = connectionConfig.getValidateAfterInactivity();
                            if (connection.isOpen() && TimeValue.isNonNegative(timeValue) && (timeValue.getDuration() == 0L || Deadline.calculate(poolEntry.getUpdated(), timeValue).isExpired()) && (protocolVersion = connection.getProtocolVersion()) != null && protocolVersion.greaterEquals(HttpVersion.HTTP_2_0)) {
                                connection.submitCommand(new PingCommand(new BasicPingHandler(result -> {
                                    if (result == null || !result.booleanValue()) {
                                        if (LOG.isDebugEnabled()) {
                                            LOG.debug("{} connection {} is stale", (Object)id, (Object)ConnPoolSupport.getId(connection));
                                        }
                                        poolEntry.discardConnection(CloseMode.GRACEFUL);
                                    }
                                    this.leaseCompleted(poolEntry);
                                })), Command.Priority.IMMEDIATE);
                                return;
                            }
                        }
                        this.leaseCompleted(poolEntry);
                    }

                    void leaseCompleted(PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry) {
                        ManagedAsyncClientConnection connection = poolEntry.getConnection();
                        if (connection != null) {
                            connection.activate();
                            if (connectionConfig.getSocketTimeout() != null) {
                                connection.setSocketTimeout(connectionConfig.getSocketTimeout());
                            }
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} endpoint leased {}", (Object)id, (Object)ConnPoolSupport.formatStats(route, state, PoolingAsyncClientConnectionManager.this.pool));
                        }
                        InternalConnectionEndpoint endpoint = new InternalConnectionEndpoint(poolEntry);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} acquired {}", (Object)id, (Object)ConnPoolSupport.getId(endpoint));
                        }
                        resultFuture.completed(endpoint);
                    }

                    @Override
                    public void failed(Exception ex) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} endpoint lease failed", (Object)id);
                        }
                        resultFuture.failed(ex);
                    }

                    @Override
                    public void cancelled() {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} endpoint lease cancelled", (Object)id);
                        }
                        resultFuture.cancel();
                    }
                });
            }

            @Override
            public AsyncConnectionEndpoint get() throws InterruptedException, ExecutionException {
                return this.resultFuture.get();
            }

            @Override
            public AsyncConnectionEndpoint get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.resultFuture.get(timeout, unit);
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return this.leaseFuture.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isDone() {
                return this.resultFuture.isDone();
            }

            @Override
            public boolean isCancelled() {
                return this.resultFuture.isCancelled();
            }
        };
    }

    @Override
    public void release(AsyncConnectionEndpoint endpoint, Object state, TimeValue keepAlive) {
        Args.notNull(endpoint, "Managed endpoint");
        Args.notNull(keepAlive, "Keep-alive time");
        PoolEntry<HttpRoute, ManagedAsyncClientConnection> entry = this.cast(endpoint).detach();
        if (entry == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} releasing endpoint", (Object)ConnPoolSupport.getId(endpoint));
        }
        if (this.isClosed()) {
            return;
        }
        ManagedAsyncClientConnection connection = entry.getConnection();
        boolean reusable = connection != null && connection.isOpen();
        try {
            if (reusable) {
                entry.updateState(state);
                entry.updateExpiry(keepAlive);
                connection.passivate();
                if (LOG.isDebugEnabled()) {
                    String s = TimeValue.isPositive(keepAlive) ? "for " + keepAlive : "indefinitely";
                    LOG.debug("{} connection {} can be kept alive {}", ConnPoolSupport.getId(endpoint), ConnPoolSupport.getId(connection), s);
                }
            }
        }
        catch (RuntimeException ex) {
            reusable = false;
            throw ex;
        }
        finally {
            this.pool.release(entry, reusable);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} connection released {}", (Object)ConnPoolSupport.getId(endpoint), (Object)ConnPoolSupport.formatStats(entry.getRoute(), entry.getState(), this.pool));
            }
        }
    }

    @Override
    public Future<AsyncConnectionEndpoint> connect(final AsyncConnectionEndpoint endpoint, ConnectionInitiator connectionInitiator, Timeout timeout, Object attachment, HttpContext context, FutureCallback<AsyncConnectionEndpoint> callback) {
        Timeout connectTimeout;
        Args.notNull(endpoint, "Endpoint");
        Args.notNull(connectionInitiator, "Connection initiator");
        final InternalConnectionEndpoint internalEndpoint = this.cast(endpoint);
        final ComplexFuture<AsyncConnectionEndpoint> resultFuture = new ComplexFuture<AsyncConnectionEndpoint>(callback);
        if (internalEndpoint.isConnected()) {
            resultFuture.completed(endpoint);
            return resultFuture;
        }
        final PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry = internalEndpoint.getPoolEntry();
        HttpRoute route = poolEntry.getRoute();
        HttpHost firstHop = route.getProxyHost() != null ? route.getProxyHost() : route.getTargetHost();
        final ConnectionConfig connectionConfig = this.resolveConnectionConfig(route);
        Timeout timeout2 = connectTimeout = timeout != null ? timeout : connectionConfig.getConnectTimeout();
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} connecting endpoint to {} ({})", ConnPoolSupport.getId(endpoint), firstHop, connectTimeout);
        }
        Future<ManagedAsyncClientConnection> connectFuture = this.connectionOperator.connect(connectionInitiator, firstHop, route.getTargetName(), route.getLocalSocketAddress(), connectTimeout, route.isTunnelled() ? null : this.resolveTlsConfig(route.getTargetHost()), context, new FutureCallback<ManagedAsyncClientConnection>(){

            @Override
            public void completed(ManagedAsyncClientConnection connection) {
                try {
                    Timeout socketTimeout;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} connected {}", (Object)ConnPoolSupport.getId(endpoint), (Object)ConnPoolSupport.getId(connection));
                    }
                    if ((socketTimeout = connectionConfig.getSocketTimeout()) != null) {
                        connection.setSocketTimeout(socketTimeout);
                    }
                    poolEntry.assignConnection(connection);
                    resultFuture.completed(internalEndpoint);
                }
                catch (RuntimeException ex) {
                    resultFuture.failed(ex);
                }
            }

            @Override
            public void failed(Exception ex) {
                resultFuture.failed(ex);
            }

            @Override
            public void cancelled() {
                resultFuture.cancel();
            }
        });
        resultFuture.setDependency(connectFuture);
        return resultFuture;
    }

    @Override
    public void upgrade(final AsyncConnectionEndpoint endpoint, Object attachment, HttpContext context, final FutureCallback<AsyncConnectionEndpoint> callback) {
        Args.notNull(endpoint, "Managed endpoint");
        final InternalConnectionEndpoint internalEndpoint = this.cast(endpoint);
        PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry = internalEndpoint.getValidatedPoolEntry();
        HttpRoute route = poolEntry.getRoute();
        HttpHost target = route.getTargetHost();
        this.connectionOperator.upgrade(poolEntry.getConnection(), target, route.getTargetName(), attachment != null ? attachment : this.resolveTlsConfig(target), context, (FutureCallback<ManagedAsyncClientConnection>)new CallbackContribution<ManagedAsyncClientConnection>(callback){

            @Override
            public void completed(ManagedAsyncClientConnection connection) {
                TlsDetails tlsDetails;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} upgraded {}", (Object)ConnPoolSupport.getId(internalEndpoint), (Object)ConnPoolSupport.getId(connection));
                }
                if ((tlsDetails = connection.getTlsDetails()) != null && ApplicationProtocol.HTTP_2.id.equals(tlsDetails.getApplicationProtocol())) {
                    connection.switchProtocol(ApplicationProtocol.HTTP_2.id, (FutureCallback<ProtocolIOSession>)new CallbackContribution<ProtocolIOSession>(callback){

                        @Override
                        public void completed(ProtocolIOSession protocolIOSession) {
                            if (callback != null) {
                                callback.completed(endpoint);
                            }
                        }
                    });
                } else if (callback != null) {
                    callback.completed(endpoint);
                }
            }
        });
    }

    @Override
    public void upgrade(AsyncConnectionEndpoint endpoint, Object attachment, HttpContext context) {
        this.upgrade(endpoint, attachment, context, null);
    }

    @Override
    public Set<HttpRoute> getRoutes() {
        return this.pool.getRoutes();
    }

    @Override
    public void setMaxTotal(int max) {
        this.pool.setMaxTotal(max);
    }

    @Override
    public int getMaxTotal() {
        return this.pool.getMaxTotal();
    }

    @Override
    public void setDefaultMaxPerRoute(int max) {
        this.pool.setDefaultMaxPerRoute(max);
    }

    @Override
    public int getDefaultMaxPerRoute() {
        return this.pool.getDefaultMaxPerRoute();
    }

    @Override
    public void setMaxPerRoute(HttpRoute route, int max) {
        this.pool.setMaxPerRoute(route, max);
    }

    @Override
    public int getMaxPerRoute(HttpRoute route) {
        return this.pool.getMaxPerRoute(route);
    }

    @Override
    public void closeIdle(TimeValue idletime) {
        if (this.isClosed()) {
            return;
        }
        this.pool.closeIdle(idletime);
    }

    @Override
    public void closeExpired() {
        if (this.isClosed()) {
            return;
        }
        this.pool.closeExpired();
    }

    @Override
    public PoolStats getTotalStats() {
        return this.pool.getTotalStats();
    }

    @Override
    public PoolStats getStats(HttpRoute route) {
        return this.pool.getStats(route);
    }

    public void setDefaultConnectionConfig(ConnectionConfig config) {
        this.connectionConfigResolver = route -> config;
    }

    public void setConnectionConfigResolver(Resolver<HttpRoute, ConnectionConfig> connectionConfigResolver) {
        this.connectionConfigResolver = connectionConfigResolver;
    }

    public void setDefaultTlsConfig(TlsConfig config) {
        this.tlsConfigResolver = host -> config;
    }

    public void setTlsConfigResolver(Resolver<HttpHost, TlsConfig> tlsConfigResolver) {
        this.tlsConfigResolver = tlsConfigResolver;
    }

    void closeIfExpired(PoolEntry<HttpRoute, ManagedAsyncClientConnection> entry) {
        long now = System.currentTimeMillis();
        if (entry.getExpiryDeadline().isBefore(now)) {
            entry.discardConnection(CloseMode.GRACEFUL);
        } else {
            ConnectionConfig connectionConfig = this.resolveConnectionConfig(entry.getRoute());
            TimeValue timeToLive = connectionConfig.getTimeToLive();
            if (timeToLive != null && Deadline.calculate(entry.getCreated(), timeToLive).isBefore(now)) {
                entry.discardConnection(CloseMode.GRACEFUL);
            }
        }
    }

    @Deprecated
    public TimeValue getValidateAfterInactivity() {
        return ConnectionConfig.DEFAULT.getValidateAfterInactivity();
    }

    @Deprecated
    public void setValidateAfterInactivity(TimeValue validateAfterInactivity) {
        this.setDefaultConnectionConfig(ConnectionConfig.custom().setValidateAfterInactivity(validateAfterInactivity).build());
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    static class InternalConnectionEndpoint
    extends AsyncConnectionEndpoint
    implements ConnectionHolder,
    Identifiable {
        private final AtomicReference<PoolEntry<HttpRoute, ManagedAsyncClientConnection>> poolEntryRef;
        private final String id;

        InternalConnectionEndpoint(PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry) {
            this.poolEntryRef = new AtomicReference<PoolEntry<HttpRoute, ManagedAsyncClientConnection>>(poolEntry);
            this.id = INCREMENTING_ID.getNextId();
        }

        @Override
        public String getId() {
            return this.id;
        }

        PoolEntry<HttpRoute, ManagedAsyncClientConnection> getPoolEntry() {
            PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry = this.poolEntryRef.get();
            if (poolEntry == null) {
                throw new ConnectionShutdownException();
            }
            return poolEntry;
        }

        PoolEntry<HttpRoute, ManagedAsyncClientConnection> getValidatedPoolEntry() {
            PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry = this.getPoolEntry();
            if (poolEntry.getConnection() == null) {
                throw new ConnectionShutdownException();
            }
            return poolEntry;
        }

        PoolEntry<HttpRoute, ManagedAsyncClientConnection> detach() {
            return this.poolEntryRef.getAndSet(null);
        }

        @Override
        public void close(CloseMode closeMode) {
            PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry = this.poolEntryRef.get();
            if (poolEntry != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} close {}", (Object)this.id, (Object)closeMode);
                }
                poolEntry.discardConnection(closeMode);
            }
        }

        @Override
        public boolean isConnected() {
            PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry = this.poolEntryRef.get();
            if (poolEntry == null) {
                return false;
            }
            ManagedAsyncClientConnection connection = poolEntry.getConnection();
            if (connection == null) {
                return false;
            }
            if (!connection.isOpen()) {
                poolEntry.discardConnection(CloseMode.IMMEDIATE);
                return false;
            }
            return true;
        }

        @Override
        public void setSocketTimeout(Timeout timeout) {
            this.getValidatedPoolEntry().getConnection().setSocketTimeout(timeout);
        }

        @Override
        public void execute(String exchangeId, AsyncClientExchangeHandler exchangeHandler, HandlerFactory<AsyncPushConsumer> pushHandlerFactory, HttpContext context) {
            ManagedAsyncClientConnection connection = this.getValidatedPoolEntry().getConnection();
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} executing exchange {} over {}", this.id, exchangeId, ConnPoolSupport.getId(connection));
            }
            context.setProtocolVersion(connection.getProtocolVersion());
            connection.submitCommand(new RequestExecutionCommand(exchangeHandler, pushHandlerFactory, context), Command.Priority.NORMAL);
        }

        @Override
        public EndpointInfo getInfo() {
            ManagedAsyncClientConnection connection;
            PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry = this.poolEntryRef.get();
            if (poolEntry != null && (connection = poolEntry.getConnection()) != null && connection.isOpen()) {
                TlsDetails tlsDetails = connection.getTlsDetails();
                return new EndpointInfo(connection.getProtocolVersion(), tlsDetails != null ? tlsDetails.getSSLSession() : null);
            }
            return null;
        }

        @Override
        public HttpConnection get() {
            PoolEntry<HttpRoute, ManagedAsyncClientConnection> poolEntry = this.poolEntryRef.get();
            return poolEntry != null ? (HttpConnection)poolEntry.getConnection() : null;
        }
    }
}

