/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.mapping;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Weigher;
import grails.web.mapping.UrlCreator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;

public class UrlCreatorCache {
    private final Cache<ReverseMappingKey, CachingUrlCreator> cacheMap;

    public UrlCreatorCache(int maxSize) {
        this.cacheMap = Caffeine.newBuilder().maximumWeight(maxSize).weigher(CachingUrlCreatorWeigher.INSTANCE).build();
    }

    public void clear() {
        this.cacheMap.invalidateAll();
    }

    public ReverseMappingKey createKey(String controller2, String action, String namespace, String pluginName, String httpMethod, Map params) {
        return new ReverseMappingKey(controller2, action, namespace, pluginName, httpMethod, params);
    }

    public UrlCreator lookup(ReverseMappingKey key) {
        return this.cacheMap.getIfPresent(key);
    }

    public UrlCreator putAndDecorate(ReverseMappingKey key, UrlCreator delegate) {
        CachingUrlCreator cachingUrlCreator = new CachingUrlCreator(delegate, key.weight() * 2);
        CachingUrlCreator prevCachingUrlCreator = this.cacheMap.asMap().putIfAbsent(key, cachingUrlCreator);
        if (prevCachingUrlCreator != null) {
            return prevCachingUrlCreator;
        }
        return cachingUrlCreator;
    }

    private static enum CachingUrlCreatorWeigher implements Weigher<ReverseMappingKey, CachingUrlCreator>
    {
        INSTANCE;


        @Override
        public int weigh(ReverseMappingKey key, CachingUrlCreator value) {
            return value.weight() + 1;
        }
    }

    public static class ReverseMappingKey {
        protected final String controller;
        protected final String action;
        protected final String namespace;
        protected final String pluginName;
        protected final String httpMethod;
        protected final String[] paramKeys;
        protected final String[] paramValues;

        public ReverseMappingKey(String controller2, String action, String namespace, String pluginName, String httpMethod, Map<Object, Object> params) {
            this.controller = controller2;
            this.action = action;
            this.namespace = namespace;
            this.pluginName = pluginName;
            this.httpMethod = httpMethod != null && !"*".equalsIgnoreCase(httpMethod) ? httpMethod : null;
            if (params != null) {
                this.paramKeys = new String[params.size()];
                this.paramValues = new String[params.size()];
                int i2 = 0;
                for (Map.Entry<Object, Object> entry : params.entrySet()) {
                    this.paramKeys[i2] = String.valueOf(entry.getKey());
                    String value = null;
                    value = entry.getValue() instanceof CharSequence ? String.valueOf(entry.getValue()) : (entry.getValue() instanceof Collection ? DefaultGroovyMethods.join((Iterable)entry.getValue(), ",") : (entry.getValue() instanceof Object[] ? DefaultGroovyMethods.join((Object[])entry.getValue(), ",") : String.valueOf(entry.getValue())));
                    this.paramValues[i2] = value;
                    ++i2;
                }
            } else {
                this.paramKeys = new String[0];
                this.paramValues = new String[0];
            }
        }

        public int weight() {
            int i2;
            int weight = 0;
            weight += this.controller != null ? this.controller.length() : 0;
            weight += this.action != null ? this.action.length() : 0;
            weight += this.namespace != null ? this.namespace.length() : 0;
            weight += this.pluginName != null ? this.pluginName.length() : 0;
            for (i2 = 0; i2 < this.paramKeys.length; ++i2) {
                weight += this.paramKeys[i2] != null ? this.paramKeys[i2].length() : 0;
            }
            for (i2 = 0; i2 < this.paramValues.length; ++i2) {
                weight += this.paramValues[i2] != null ? this.paramValues[i2].length() : 0;
            }
            return weight;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.action == null ? 0 : this.action.hashCode());
            result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
            result = 31 * result + (this.pluginName == null ? 0 : this.pluginName.hashCode());
            result = 31 * result + (this.controller == null ? 0 : this.controller.hashCode());
            result = 31 * result + Arrays.hashCode(this.paramKeys);
            result = 31 * result + Arrays.hashCode(this.paramValues);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReverseMappingKey other = (ReverseMappingKey)obj;
            if (this.action == null ? other.action != null : !this.action.equals(other.action)) {
                return false;
            }
            if (this.controller == null ? other.controller != null : !this.controller.equals(other.controller)) {
                return false;
            }
            if (this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace)) {
                return false;
            }
            if (this.pluginName == null ? other.pluginName != null : !this.pluginName.equals(other.pluginName)) {
                return false;
            }
            if (this.httpMethod == null ? other.httpMethod != null : !this.httpMethod.equals(other.httpMethod)) {
                return false;
            }
            if (!Arrays.equals(this.paramKeys, other.paramKeys)) {
                return false;
            }
            return Arrays.equals(this.paramValues, other.paramValues);
        }

        public String toString() {
            return "UrlCreatorCache.ReverseMappingKey [action=" + this.action + ", controller=" + this.controller + ", namespace=" + this.namespace + ", plugin=" + this.pluginName + ", paramKeys=" + Arrays.toString(this.paramKeys) + ", paramValues=" + Arrays.toString(this.paramValues) + "]";
        }
    }

    private class CachingUrlCreator
    implements UrlCreator {
        private UrlCreator delegate;
        private ConcurrentHashMap<UrlCreatorKey, String> cache = new ConcurrentHashMap();
        private final int weight;

        public CachingUrlCreator(UrlCreator delegate, int weight) {
            this.delegate = delegate;
            this.weight = weight;
        }

        public int weight() {
            return this.weight;
        }

        @Override
        public String createRelativeURL(String controller2, String action, Map parameterValues, String encoding, String fragment) {
            return this.createRelativeURL(controller2, action, null, null, parameterValues, encoding, fragment);
        }

        @Override
        public String createRelativeURL(String controller2, String action, String pluginName, Map parameterValues, String encoding) {
            return this.createRelativeURL(controller2, action, null, pluginName, parameterValues, encoding);
        }

        @Override
        public String createRelativeURL(String controller2, String action, String namespace, String pluginName, Map parameterValues, String encoding, String fragment) {
            UrlCreatorKey key = new UrlCreatorKey(controller2, action, namespace, pluginName, null, parameterValues, encoding, fragment, 0);
            String url = this.cache.get(key);
            if (url == null) {
                url = this.delegate.createRelativeURL(controller2, action, namespace, pluginName, parameterValues, encoding, fragment);
                this.cache.put(key, url);
            }
            return url;
        }

        @Override
        public String createRelativeURL(String controller2, String action, Map parameterValues, String encoding) {
            return this.createRelativeURL(controller2, action, null, null, parameterValues, encoding);
        }

        @Override
        public String createRelativeURL(String controller2, String action, String namespace, String pluginName, Map parameterValues, String encoding) {
            UrlCreatorKey key = new UrlCreatorKey(controller2, action, namespace, pluginName, null, parameterValues, encoding, null, 0);
            String url = this.cache.get(key);
            if (url == null) {
                url = this.delegate.createRelativeURL(controller2, action, namespace, pluginName, parameterValues, encoding);
                this.cache.put(key, url);
            }
            return url;
        }

        @Override
        public String createURL(String controller2, String action, Map parameterValues, String encoding, String fragment) {
            return this.createURL(controller2, action, null, null, parameterValues, encoding, fragment);
        }

        @Override
        public String createURL(String controller2, String action, String pluginName, Map parameterValues, String encoding) {
            return this.createURL(controller2, action, null, pluginName, parameterValues, encoding);
        }

        @Override
        public String createURL(String controller2, String action, String namespace, String pluginName, Map parameterValues, String encoding, String fragment) {
            UrlCreatorKey key = new UrlCreatorKey(controller2, action, namespace, pluginName, null, parameterValues, encoding, fragment, 1);
            String url = this.cache.get(key);
            if (url == null) {
                url = this.delegate.createURL(controller2, action, namespace, pluginName, parameterValues, encoding, fragment);
                this.cache.put(key, url);
            }
            return url;
        }

        @Override
        public String createURL(String controller2, String action, Map parameterValues, String encoding) {
            return this.createURL(controller2, action, null, null, parameterValues, encoding);
        }

        @Override
        public String createURL(String controller2, String action, String namespace, String pluginName, Map parameterValues, String encoding) {
            UrlCreatorKey key = new UrlCreatorKey(controller2, action, namespace, pluginName, null, parameterValues, encoding, null, 1);
            String url = this.cache.get(key);
            if (url == null) {
                url = this.delegate.createURL(controller2, action, namespace, pluginName, parameterValues, encoding);
                this.cache.put(key, url);
            }
            return url;
        }

        @Override
        public String createURL(Map parameterValues, String encoding, String fragment) {
            return this.delegate.createURL(parameterValues, encoding, fragment);
        }

        @Override
        public String createURL(Map parameterValues, String encoding) {
            return this.delegate.createURL(parameterValues, encoding);
        }
    }

    private static class UrlCreatorKey
    extends ReverseMappingKey {
        protected final String encoding;
        protected final String fragment;
        protected final int urlType;

        public UrlCreatorKey(String controller2, String action, String namespace, String pluginName, String httpMethod, Map<Object, Object> params, String encoding, String fragment, int urlType) {
            super(controller2, action, namespace, pluginName, httpMethod, params);
            this.encoding = encoding != null ? encoding.toLowerCase() : null;
            this.fragment = fragment;
            this.urlType = urlType;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.encoding == null ? 0 : this.encoding.hashCode());
            result = 31 * result + (this.fragment == null ? 0 : this.fragment.hashCode());
            result = 31 * result + this.urlType;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UrlCreatorKey other = (UrlCreatorKey)obj;
            if (this.encoding == null ? other.encoding != null : !this.encoding.equals(other.encoding)) {
                return false;
            }
            if (this.fragment == null ? other.fragment != null : !this.fragment.equals(other.fragment)) {
                return false;
            }
            return this.urlType == other.urlType;
        }

        @Override
        public String toString() {
            return "UrlCreatorCache.UrlCreatorKey [encoding=" + this.encoding + ", fragment=" + this.fragment + ", urlType=" + this.urlType + ", action=" + this.action + ", controller=" + this.controller + ", namespace=" + this.namespace + ", plugin=" + this.pluginName + ", paramKeys=" + Arrays.toString(this.paramKeys) + ", paramValues=" + Arrays.toString(this.paramValues) + "]";
        }
    }
}

