/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.diagnostics;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.SpringBootExceptionReporter;
import org.springframework.boot.diagnostics.FailureAnalysis;
import org.springframework.boot.diagnostics.FailureAnalysisReporter;
import org.springframework.boot.diagnostics.FailureAnalyzer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.log.LogMessage;

final class FailureAnalyzers
implements SpringBootExceptionReporter {
    private static final Log logger = LogFactory.getLog(FailureAnalyzers.class);
    private final SpringFactoriesLoader springFactoriesLoader;
    private final List<FailureAnalyzer> analyzers;

    public FailureAnalyzers(ConfigurableApplicationContext context) {
        this(context, SpringFactoriesLoader.forDefaultResourceLocation(context != null ? context.getClassLoader() : null));
    }

    FailureAnalyzers(ConfigurableApplicationContext context, SpringFactoriesLoader springFactoriesLoader) {
        this.springFactoriesLoader = springFactoriesLoader;
        this.analyzers = FailureAnalyzers.loadFailureAnalyzers(context, this.springFactoriesLoader);
    }

    private static List<FailureAnalyzer> loadFailureAnalyzers(ConfigurableApplicationContext context, SpringFactoriesLoader springFactoriesLoader) {
        return springFactoriesLoader.load(FailureAnalyzer.class, FailureAnalyzers.getArgumentResolver(context), SpringFactoriesLoader.FailureHandler.logging(logger));
    }

    private static SpringFactoriesLoader.ArgumentResolver getArgumentResolver(ConfigurableApplicationContext context) {
        if (context == null) {
            return null;
        }
        SpringFactoriesLoader.ArgumentResolver argumentResolver = SpringFactoriesLoader.ArgumentResolver.of(BeanFactory.class, context.getBeanFactory());
        argumentResolver = argumentResolver.and(Environment.class, context.getEnvironment());
        return argumentResolver;
    }

    @Override
    public boolean reportException(Throwable failure) {
        FailureAnalysis analysis = this.analyze(failure, this.analyzers);
        return this.report(analysis);
    }

    private FailureAnalysis analyze(Throwable failure, List<FailureAnalyzer> analyzers) {
        for (FailureAnalyzer analyzer : analyzers) {
            try {
                FailureAnalysis analysis = analyzer.analyze(failure);
                if (analysis == null) continue;
                return analysis;
            }
            catch (Throwable ex) {
                logger.trace(LogMessage.format("FailureAnalyzer %s failed", (Object)analyzer), ex);
            }
        }
        return null;
    }

    private boolean report(FailureAnalysis analysis) {
        List<FailureAnalysisReporter> reporters = this.springFactoriesLoader.load(FailureAnalysisReporter.class);
        if (analysis == null || reporters.isEmpty()) {
            return false;
        }
        for (FailureAnalysisReporter reporter : reporters) {
            reporter.report(analysis);
        }
        return true;
    }
}

