/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.function;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Set;
import java.util.function.BiConsumer;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.function.EntityResponse;
import org.springframework.web.servlet.function.HandlerFunction;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.ServerResponse;

class ResourceHandlerFunction
implements HandlerFunction<ServerResponse> {
    private static final Set<HttpMethod> SUPPORTED_METHODS = Set.of(HttpMethod.GET, HttpMethod.HEAD, HttpMethod.OPTIONS);
    private final Resource resource;
    private final BiConsumer<Resource, HttpHeaders> headersConsumer;

    public ResourceHandlerFunction(Resource resource, BiConsumer<Resource, HttpHeaders> headersConsumer) {
        this.resource = resource;
        this.headersConsumer = headersConsumer;
    }

    @Override
    public ServerResponse handle(ServerRequest request) {
        HttpMethod method = request.method();
        if (HttpMethod.GET.equals(method)) {
            return EntityResponse.fromObject(this.resource).headers(headers -> this.headersConsumer.accept(this.resource, (HttpHeaders)headers)).build();
        }
        if (HttpMethod.HEAD.equals(method)) {
            HeadMethodResource headResource = new HeadMethodResource(this.resource);
            return EntityResponse.fromObject(headResource).headers(headers -> this.headersConsumer.accept(this.resource, (HttpHeaders)headers)).build();
        }
        if (HttpMethod.OPTIONS.equals(method)) {
            return ((ServerResponse.BodyBuilder)ServerResponse.ok().allow(SUPPORTED_METHODS)).build();
        }
        return ((ServerResponse.BodyBuilder)ServerResponse.status(HttpStatus.METHOD_NOT_ALLOWED).allow(SUPPORTED_METHODS)).build();
    }

    private static class HeadMethodResource
    implements Resource {
        private static final byte[] EMPTY = new byte[0];
        private final Resource delegate;

        public HeadMethodResource(Resource delegate) {
            this.delegate = delegate;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(EMPTY);
        }

        @Override
        public boolean exists() {
            return this.delegate.exists();
        }

        @Override
        public URL getURL() throws IOException {
            return this.delegate.getURL();
        }

        @Override
        public URI getURI() throws IOException {
            return this.delegate.getURI();
        }

        @Override
        public File getFile() throws IOException {
            return this.delegate.getFile();
        }

        @Override
        public long contentLength() throws IOException {
            return this.delegate.contentLength();
        }

        @Override
        public long lastModified() throws IOException {
            return this.delegate.lastModified();
        }

        @Override
        public Resource createRelative(String relativePath) throws IOException {
            return this.delegate.createRelative(relativePath);
        }

        @Override
        @Nullable
        public String getFilename() {
            return this.delegate.getFilename();
        }

        @Override
        public String getDescription() {
            return this.delegate.getDescription();
        }
    }
}

