/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.thread.IgniteThread;
import org.apache.ignite.internal.thread.IgniteThreadFactory;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.raft.jraft.conf.Configuration;
import org.apache.ignite.raft.jraft.core.NodeImpl;
import org.apache.ignite.raft.jraft.core.Scheduler;
import org.apache.ignite.raft.jraft.core.TimerManager;
import org.apache.ignite.raft.jraft.entity.PeerId;
import org.apache.ignite.raft.jraft.option.BootstrapOptions;
import org.apache.ignite.raft.jraft.option.NodeOptions;
import org.apache.ignite.raft.jraft.option.RpcOptions;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;
import org.apache.ignite.raft.jraft.util.StringUtils;
import org.apache.ignite.raft.jraft.util.ThreadPoolUtil;
import org.apache.ignite.raft.jraft.util.Utils;
import org.apache.ignite.raft.jraft.util.concurrent.DefaultFixedThreadsExecutorGroupFactory;
import org.apache.ignite.raft.jraft.util.concurrent.FixedThreadsExecutorGroup;
import org.apache.ignite.raft.jraft.util.concurrent.FixedThreadsExecutorGroupFactory;
import org.apache.ignite.raft.jraft.util.timer.DefaultTimer;
import org.apache.ignite.raft.jraft.util.timer.Timer;

public final class JRaftUtils {
    private static final IgniteLogger LOG = Loggers.forClass(JRaftUtils.class);

    public static boolean bootstrap(BootstrapOptions opts) throws InterruptedException {
        NodeImpl node = new NodeImpl("bootstrap", new PeerId("127.0.0.1", 0));
        NodeOptions nodeOpts = opts.getNodeOptions();
        if (nodeOpts != null) {
            nodeOpts.setStripes(1);
            nodeOpts.setLogStripesCount(1);
        }
        boolean ret = node.bootstrap(opts);
        node.shutdown();
        node.join();
        return ret;
    }

    public static ExecutorService createExecutor(String nodeName, String poolName, int number) {
        return JRaftUtils.createExecutor(number, JRaftUtils.createThreadFactory(nodeName, poolName));
    }

    private static ExecutorService createExecutor(int number, IgniteThreadFactory threadFactory) {
        if (number <= 0) {
            throw new IllegalArgumentException();
        }
        return ThreadPoolUtil.newBuilder().poolName(threadFactory.prefix()).enableMetric(true).coreThreads(number).maximumThreads(number).keepAliveSeconds(60L).workQueue(new LinkedBlockingQueue<Runnable>()).threadFactory((ThreadFactory)threadFactory).build();
    }

    public static ExecutorService createCommonExecutor(NodeOptions opts) {
        String poolName = "JRaft-Common-Executor";
        return JRaftUtils.createExecutor(opts.getCommonThreadPollSize(), IgniteThreadFactory.create((String)opts.getServerName(), (String)poolName, (boolean)true, (IgniteLogger)LOG, (ThreadOperation[])new ThreadOperation[]{ThreadOperation.TX_STATE_STORAGE_ACCESS}));
    }

    public static FixedThreadsExecutorGroup createAppendEntriesExecutor(final NodeOptions opts) {
        final String poolName = "JRaft-AppendEntries-Processor";
        return JRaftUtils.createStripedExecutor(IgniteThread.threadPrefix((String)opts.getServerName(), (String)"JRaft-AppendEntries-Processor"), Utils.APPEND_ENTRIES_THREADS_POOL_SIZE, Utils.MAX_APPEND_ENTRIES_TASKS_PER_THREAD, new DefaultFixedThreadsExecutorGroupFactory(){

            @Override
            protected ThreadFactory newDaemonThreadFactory(String fullPoolName) {
                return IgniteThreadFactory.create((String)opts.getServerName(), (String)poolName, (boolean)true, (IgniteLogger)LOG, (ThreadOperation[])new ThreadOperation[]{ThreadOperation.TX_STATE_STORAGE_ACCESS});
            }
        });
    }

    public static ExecutorService createRequestExecutor(NodeOptions opts) {
        return JRaftUtils.createExecutor(opts.getServerName(), "JRaft-Request-Processor", opts.getRaftRpcThreadPoolSize());
    }

    public static ExecutorService createClientExecutor(RpcOptions opts, String name) {
        IgniteThreadFactory threadFactory = JRaftUtils.createThreadFactory(name, "JRaft-Response-Processor");
        return ThreadPoolUtil.newBuilder().poolName(threadFactory.prefix()).enableMetric(true).coreThreads(opts.getRpcProcessorThreadPoolSize() / 3).maximumThreads(opts.getRpcProcessorThreadPoolSize()).keepAliveSeconds(60L).workQueue(new ArrayBlockingQueue<Runnable>(10000)).threadFactory((ThreadFactory)threadFactory).build();
    }

    public static Scheduler createScheduler(NodeOptions opts) {
        return new TimerManager(opts.getTimerPoolSize(), IgniteThread.threadPrefix((String)opts.getServerName(), (String)"JRaft-Node-Scheduler"));
    }

    public static Timer createTimer(NodeOptions opts, String name) {
        return new DefaultTimer(opts.getTimerPoolSize(), IgniteThread.threadPrefix((String)opts.getServerName(), (String)name));
    }

    public static FixedThreadsExecutorGroup createStripedExecutor(String prefix, int number, int tasksPerThread) {
        return JRaftUtils.createStripedExecutor(prefix, number, tasksPerThread, DefaultFixedThreadsExecutorGroupFactory.INSTANCE);
    }

    private static FixedThreadsExecutorGroup createStripedExecutor(String prefix, int number, int tasksPerThread, FixedThreadsExecutorGroupFactory executorGroupFactory) {
        return executorGroupFactory.newExecutorGroup(number, prefix, tasksPerThread, true);
    }

    public static IgniteThreadFactory createThreadFactory(String nodeName, String poolName) {
        return IgniteThreadFactory.create((String)nodeName, (String)poolName, (boolean)true, (IgniteLogger)LOG, (ThreadOperation[])new ThreadOperation[0]);
    }

    public static Configuration getConfiguration(String s) {
        Configuration conf = new Configuration();
        if (StringUtils.isBlank(s)) {
            return conf;
        }
        if (conf.parse(s)) {
            return conf;
        }
        throw new IllegalArgumentException("Invalid conf str:" + s);
    }

    public static PeerId getPeerId(String s) {
        PeerId peer = new PeerId();
        if (StringUtils.isBlank(s)) {
            return peer;
        }
        if (peer.parse(s)) {
            return peer;
        }
        throw new IllegalArgumentException("Invalid peer str:" + s);
    }

    private JRaftUtils() {
    }

    public static boolean isHeartbeatRequest(RpcRequests.AppendEntriesRequest request) {
        return request.entriesList() == null && request.data() == null;
    }
}

