/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.fsm;

import java.util.function.Function;
import org.apache.ignite.internal.sql.engine.exec.fsm.ExecutionPhase;
import org.apache.ignite.internal.sql.engine.exec.fsm.Query;

class Transition {
    private final ExecutionPhase from;
    private final Function<Query, ExecutionPhase> to;

    Transition(ExecutionPhase from, Function<Query, ExecutionPhase> to) {
        this.from = from;
        this.to = to;
    }

    ExecutionPhase from() {
        return this.from;
    }

    void move(Query query) {
        ExecutionPhase newPhase = this.to.apply(query);
        ExecutionPhase current = query.currentPhase();
        assert (current == this.from) : current;
        query.moveTo(newPhase);
    }
}

