/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rule;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.ignite.internal.sql.engine.rel.IgniteLimit;
import org.apache.ignite.internal.sql.engine.rel.IgniteSort;
import org.apache.ignite.internal.sql.engine.rule.ImmutableSortRemoveRule;
import org.immutables.value.Value;

@Value.Enclosing
public class SortRemoveRule
extends RelRule<Config> {
    public static final RelOptRule INSTANCE = Config.INSTANCE.toRule();

    private SortRemoveRule(Config cfg) {
        super((RelRule.Config)cfg);
    }

    public void onMatch(RelOptRuleCall call) {
        IgniteSort sort = (IgniteSort)call.rel(0);
        if (sort.offset == null && sort.fetch == null) {
            call.transformTo(SortRemoveRule.convert((RelNode)sort.getInput(), (RelTraitSet)sort.getTraitSet()));
            return;
        }
        call.transformTo((RelNode)new IgniteLimit(sort.getCluster(), sort.getTraitSet(), SortRemoveRule.convert((RelNode)sort.getInput(), (RelTraitSet)sort.getTraitSet()), sort.offset, sort.fetch));
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config INSTANCE = (Config)ImmutableSortRemoveRule.Config.of().withDescription("SortRemoveRule").withOperandSupplier(o0 -> o0.operand(IgniteSort.class).anyInputs()).as(Config.class);

        default public SortRemoveRule toRule() {
            return new SortRemoveRule(this);
        }
    }
}

