/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import java.util.Objects;
import org.apache.jena.graph.Node;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.engine.constraint.ConstraintTerm;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.parser.ConstraintVisitor;
import org.apache.jena.shacl.sys.ShaclSystem;
import org.apache.jena.shacl.validation.ReportItem;
import org.apache.jena.shacl.vocabulary.SHJ;

public class JLogConstraint
extends ConstraintTerm {
    private final String message;

    public JLogConstraint(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public Node getComponent() {
        return SHJ.LogConstraintComponent;
    }

    @Override
    public ReportItem validate(ValidationContext vCxt, Node n) {
        String msg = String.format("%s[%s]", this.message, ShLib.displayStr(n));
        ShaclSystem.shaclSystemLogger.warn(msg);
        return null;
    }

    @Override
    public void visit(ConstraintVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return "Log[" + this.message + "]";
    }

    public int hashCode() {
        return Objects.hash(this.message);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JLogConstraint other = (JLogConstraint)obj;
        return Objects.equals(this.message, other.message);
    }
}

