/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.snappy.SnappyCompressorInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IOX;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.io.Writer2;
import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.atlas.lib.StrUtils;

public class IO {
    public static final int EOF = -1;
    public static final int UNSET = -2;
    private static final String ext_gz = "gz";
    private static final String ext_bz2 = "bz2";
    private static final String ext_sz = "sz";
    private static final int NOT_FOUND = -1;
    private static final String EMPTY_STRING = "";
    private static final String EXTENSION_SEPARATOR = ".";
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private static final int BUFSIZE_IN = 131072;
    private static final int BUFSIZE_OUT = 131072;
    private static final int WHOLE_FILE_BUFFER_SIZE = 32768;
    private static int SKIP_BUFFER_LEN = 65536;
    private static byte[] SKIP_BUFFER = null;
    private static int SKIP_BUFFER_LEN_R = 16384;
    private static char[] SKIP_BUFFER_R = null;

    public static InputStream openFile(String filename) {
        try {
            return IO.openFileEx(filename);
        }
        catch (IOException ex) {
            IO.exception(ex);
            return null;
        }
    }

    public static InputStream openFileBuffered(String filename) {
        InputStream in = IO.openFile(filename);
        return IO.ensureBuffered(in);
    }

    public static InputStream openFileEx(String filename) throws IOException, FileNotFoundException {
        String ext;
        if (filename == null || filename.equals("-")) {
            return System.in;
        }
        if (filename.startsWith("file:")) {
            filename = filename.substring("file:".length());
            filename = IRILib.decodeHex(filename);
        }
        InputStream in = new FileInputStream(filename);
        switch (ext = IO.getExtension(filename)) {
            case "": {
                return in;
            }
            case "gz": {
                return new GZIPInputStream(in, 8192);
            }
            case "bz2": {
                in = IO.ensureBuffered(in);
                return new BZip2CompressorInputStream(in, true);
            }
            case "sz": {
                return new SnappyCompressorInputStream(in);
            }
        }
        return in;
    }

    private static int indexOfLastSeparator(String fileName) {
        if (fileName == null) {
            return -1;
        }
        int lastUnixPos = fileName.lastIndexOf(47);
        int lastWindowsPos = fileName.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    private static int indexOfExtension(String fileName) throws IllegalArgumentException {
        if (fileName == null) {
            return -1;
        }
        int extensionPos = fileName.lastIndexOf(EXTENSION_SEPARATOR);
        int lastSeparator = IO.indexOfLastSeparator(fileName);
        return lastSeparator > extensionPos ? -1 : extensionPos;
    }

    private static String getExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        int index = IO.indexOfExtension(fileName);
        if (index == -1) {
            return EMPTY_STRING;
        }
        return fileName.substring(index + 1);
    }

    public static String filenameNoCompression(String filename) {
        String ext;
        switch (ext = IO.getExtension(filename)) {
            case "": {
                return filename;
            }
            case "gz": 
            case "bz2": 
            case "sz": {
                return filename.substring(0, filename.length() - (ext.length() + 1));
            }
        }
        return filename;
    }

    public static Reader openFileUTF8(String filename) {
        return IO.openFileReader(filename, StandardCharsets.UTF_8);
    }

    public static Reader openFileASCII(String filename) {
        return IO.openFileReader(filename, StandardCharsets.US_ASCII);
    }

    private static Reader openFileReader(String filename, Charset charset) {
        InputStream in = IO.openFile(filename);
        return new InputStreamReader(in, charset);
    }

    public static Reader asUTF8(InputStream in) {
        return new InputStreamReader(in, StandardCharsets.UTF_8);
    }

    public static Reader asASCII(InputStream in) {
        CharsetDecoder dec = StandardCharsets.US_ASCII.newDecoder();
        dec.onMalformedInput(CodingErrorAction.REPORT);
        return new InputStreamReader(in, dec);
    }

    public static BufferedReader asBufferedUTF8(InputStream in) {
        return new BufferedReader(IO.asUTF8(in), 65536);
    }

    public static Writer asUTF8(OutputStream out) {
        return new OutputStreamWriter(out, StandardCharsets.UTF_8);
    }

    public static Writer asASCII(OutputStream out) {
        return new OutputStreamWriter(out, StandardCharsets.US_ASCII);
    }

    public static Writer asBufferedUTF8(OutputStream out) {
        OutputStreamWriter w = new OutputStreamWriter(out, StandardCharsets.UTF_8);
        return IO.ensureBuffered(w);
    }

    public static OutputStream openOutputFile(String filename) {
        try {
            return IO.openOutputFileEx(filename);
        }
        catch (IOException ex) {
            IO.exception(ex);
            return null;
        }
    }

    public static OutputStream openOutputFileEx(String filename) throws FileNotFoundException, IOException {
        String ext;
        if (filename == null || filename.equals("-")) {
            return System.out;
        }
        if (filename.startsWith("file:")) {
            filename = filename.substring("file:".length());
            filename = IRILib.decodeHex(filename);
        }
        FileOutputStream out = new FileOutputStream(filename);
        switch (ext = IO.getExtension(filename)) {
            case "": {
                return out;
            }
            case "gz": {
                return new GZIPOutputStream(out);
            }
            case "bz2": {
                return new BZip2CompressorOutputStream((OutputStream)out);
            }
            case "sz": {
                throw new UnsupportedOperationException("Snappy output");
            }
        }
        return out;
    }

    public static OutputStream sink() {
        return OutputStream.nullOutputStream();
    }

    public static AWriter wrap(Writer w) {
        return Writer2.wrap(w);
    }

    public static AWriter wrapUTF8(OutputStream out) {
        return IO.wrap(IO.asUTF8(out));
    }

    public static AWriter wrapASCII(OutputStream out) {
        return IO.wrap(IO.asASCII(out));
    }

    public static PrintWriter asPrintWriterUTF8(OutputStream out) {
        return new PrintWriter(IO.asUTF8(out));
    }

    public static boolean isEmptyDirectory(String directory) {
        boolean bl;
        block9: {
            Path path = Path.of(directory, new String[0]);
            DirectoryStream<Path> dirStream = Files.newDirectoryStream(path);
            try {
                boolean bl2 = bl = !dirStream.iterator().hasNext();
                if (dirStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (dirStream != null) {
                        try {
                            dirStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NotDirectoryException ex) {
                    return false;
                }
                catch (IOException ex) {
                    IO.exception(ex);
                    return false;
                }
            }
            dirStream.close();
        }
        return bl;
    }

    public static boolean exists(String fsname) {
        Path path = Path.of(fsname, new String[0]);
        return Files.exists(path, new LinkOption[0]);
    }

    public static boolean isDirectory(String directory) {
        Path path = Path.of(directory, new String[0]);
        return Files.isDirectory(path, new LinkOption[0]);
    }

    public static void close(org.apache.jena.atlas.lib.Closeable resource) {
        resource.close();
    }

    public static void closeSilent(org.apache.jena.atlas.lib.Closeable resource) {
        try {
            resource.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(Closeable resource) {
        if (resource == null) {
            return;
        }
        try {
            resource.close();
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    public static void closeSilent(Closeable resource) {
        if (resource == null) {
            return;
        }
        try {
            resource.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(AWriter resource) {
        if (resource == null) {
            return;
        }
        resource.close();
    }

    public static void closeSilent(AWriter resource) {
        if (resource == null) {
            return;
        }
        try {
            resource.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(IndentedWriter resource) {
        if (resource == null) {
            return;
        }
        resource.close();
    }

    public static void closeSilent(IndentedWriter resource) {
        if (resource == null) {
            return;
        }
        try {
            resource.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void exception(String message) {
        throw new RuntimeIOException(message);
    }

    public static void exception(IOException ex) {
        throw new RuntimeIOException(ex);
    }

    public static void exception(String msg, IOException ex) {
        throw new RuntimeIOException(msg, ex);
    }

    public static void flush(OutputStream out) {
        if (out == null) {
            return;
        }
        try {
            out.flush();
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    public static void flush(Writer out) {
        if (out == null) {
            return;
        }
        try {
            out.flush();
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    public static void flush(AWriter out) {
        if (out == null) {
            return;
        }
        out.flush();
    }

    public static InputStream ensureBuffered(InputStream input) {
        if (input instanceof BufferedInputStream) {
            return input;
        }
        if (input instanceof ByteArrayInputStream) {
            return input;
        }
        return new BufferedInputStream(input, 131072);
    }

    public static Reader ensureBuffered(Reader input) {
        if (input instanceof BufferedReader) {
            return input;
        }
        if (input instanceof StringReader) {
            return input;
        }
        return new BufferedReader(input, 65536);
    }

    public static OutputStream ensureBuffered(OutputStream output) {
        if (output instanceof BufferedOutputStream) {
            return output;
        }
        if (output instanceof ByteArrayOutputStream) {
            return output;
        }
        return new BufferedOutputStream(output, 131072);
    }

    public static Writer ensureBuffered(Writer output) {
        if (output instanceof BufferedWriter) {
            return output;
        }
        if (output instanceof StringWriter) {
            return output;
        }
        return new BufferedWriter(output, 65536);
    }

    public static byte[] readWholeFile(InputStream in) {
        byte[] byArray;
        ByteArrayOutputStream out = new ByteArrayOutputStream(32768);
        try {
            int l;
            byte[] buff = new byte[32768];
            while ((l = in.read(buff)) > 0) {
                out.write(buff, 0, l);
            }
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                IO.exception(ex);
                return null;
            }
        }
        out.close();
        return byArray;
    }

    public static String readWholeFileAsUTF8(String filename) {
        String string;
        FileInputStream in = new FileInputStream(filename);
        try {
            string = IO.readWholeFileAsUTF8(in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                IO.exception(ex);
                return null;
            }
        }
        ((InputStream)in).close();
        return string;
    }

    public static String readWholeFileAsUTF8(InputStream in) {
        String string;
        block8: {
            Reader r = IO.asUTF8(in);
            try {
                string = IO.readWholeFileAsUTF8(r);
                if (r == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    IO.exception(ex);
                    return null;
                }
            }
            r.close();
        }
        return string;
    }

    public static String abbreviate(InputStream in, Charset charset, int maxWidth, String abbrevMarker) throws IOException {
        return IO.abbreviate(new InputStreamReader(in, charset), maxWidth, abbrevMarker);
    }

    public static String abbreviate(Reader reader, int maxWidth, String abbrevMarker) throws IOException {
        char[] buffer = new char[maxWidth + 1];
        int n = IOUtils.read((Reader)reader, (char[])buffer);
        StringBuilder sb = new StringBuilder();
        sb.append(buffer, 0, Math.min(n, maxWidth));
        if (n > maxWidth) {
            sb.append(abbrevMarker);
        }
        return sb.toString();
    }

    private static String readWholeFileAsUTF8(Reader r) throws IOException {
        int WHOLE_FILE_BUFFER_SIZE = 32768;
        try (StringWriter sw = new StringWriter(32768);){
            int l;
            char[] buff = new char[32768];
            while ((l = r.read(buff)) >= 0) {
                sw.write(buff, 0, l);
            }
            String string = sw.toString();
            return string;
        }
    }

    public static void writeStringAsUTF8(String filename, String content) throws IOException {
        try (OutputStream out = IO.openOutputFileEx(filename);){
            IO.writeStringAsUTF8(out, content);
            out.flush();
        }
    }

    public static void writeStringAsUTF8(OutputStream out, String content) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(out, StandardCharsets.UTF_8);
        w.write(content);
        ((Writer)w).flush();
    }

    public static ByteBuffer stringToByteBuffer(String str) {
        byte[] b = StrUtils.asUTF8bytes(str);
        return ByteBuffer.wrap(b);
    }

    public static String byteBufferToString(ByteBuffer bb) {
        byte[] b = new byte[bb.remaining()];
        bb.get(b);
        return StrUtils.fromUTF8bytes(b);
    }

    public static String uniqueFilename(String directory, String base, String ext) {
        File d = new File(directory);
        if (!d.exists()) {
            throw new IllegalArgumentException("Not found: " + directory);
        }
        try {
            String fn0;
            String fn = fn0 = d.getCanonicalPath() + File.separator + base;
            int x = 1;
            while (true) {
                File f;
                if (ext != null) {
                    fn = fn + EXTENSION_SEPARATOR + ext;
                }
                if (!(f = new File(fn)).exists()) {
                    return fn;
                }
                fn = fn0 + "-" + x++;
            }
        }
        catch (IOException e) {
            IO.exception(e);
            return null;
        }
    }

    public static void deleteAll(Path start) {
        try {
            Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                    if (e == null) {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                    throw e;
                }
            });
        }
        catch (IOException ex) {
            throw IOX.exception(ex);
        }
    }

    public static void skipToEnd(InputStream input) {
        if (SKIP_BUFFER == null) {
            SKIP_BUFFER = new byte[SKIP_BUFFER_LEN];
        }
        try {
            long rLen;
            while ((rLen = (long)input.read(SKIP_BUFFER, 0, SKIP_BUFFER_LEN)) >= 0L) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void skipToEnd(Reader input) {
        if (SKIP_BUFFER_R == null) {
            SKIP_BUFFER_R = new char[SKIP_BUFFER_LEN_R];
        }
        try {
            long rLen;
            while ((rLen = (long)input.read(SKIP_BUFFER_R, 0, SKIP_BUFFER_LEN_R)) >= 0L) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

