/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.core.QuerySolutionBase;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingLib;
import org.apache.jena.sparql.util.ModelUtils;

public class ResultBinding
extends QuerySolutionBase {
    Binding binding;
    Model model;

    public ResultBinding(Model _model, Binding _binding) {
        this.model = _model;
        this.binding = _binding;
    }

    @Override
    protected RDFNode _get(String varName) {
        Node n = this.binding.get(Var.alloc(varName));
        if (n == null) {
            return null;
        }
        return ModelUtils.convertGraphNodeToRDFNode(n, this.model);
    }

    @Override
    protected boolean _contains(String varName) {
        return this.binding.contains(Var.alloc(varName));
    }

    @Override
    public Iterator<String> varNames() {
        ArrayList<String> x = new ArrayList<String>();
        Iterator<Var> iter = this.binding.vars();
        while (iter.hasNext()) {
            Var v = iter.next();
            x.add(v.getVarName());
        }
        return x.iterator();
    }

    public Binding getBinding() {
        return this.binding;
    }

    public String toString() {
        if (this.binding == null) {
            return "<no binding>";
        }
        return this.binding.toString();
    }

    public static boolean equals(ResultBinding rb1, ResultBinding rb2) {
        return BindingLib.equals(rb1.getBinding(), rb2.getBinding());
    }
}

