/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.jsonpath;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.StreamCache;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.jsonpath.JsonPathAdapter;
import org.apache.camel.jsonpath.JsonStream;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPathEngine {
    private static final Logger LOG = LoggerFactory.getLogger(JsonPathEngine.class);
    private static final String JACKSON_JSON_ADAPTER = "org.apache.camel.jsonpath.jackson.JacksonJsonAdapter";
    private static final Pattern SIMPLE_PATTERN = Pattern.compile("\\$\\{[^\\}]+\\}", 8);
    private final String expression;
    private final boolean writeAsString;
    private final String headerName;
    private final JsonPath path;
    private final Configuration configuration;
    private JsonPathAdapter adapter;
    private volatile boolean initJsonAdapter;

    @Deprecated
    public JsonPathEngine(String expression) {
        this(expression, false, false, true, null, null);
    }

    public JsonPathEngine(String expression, boolean writeAsString, boolean suppressExceptions, boolean allowSimple, String headerName, Option[] options) {
        Matcher matcher;
        this.expression = expression;
        this.writeAsString = writeAsString;
        this.headerName = headerName;
        Configuration.ConfigurationBuilder builder = Configuration.builder();
        if (options != null) {
            builder.options(options);
        }
        if (suppressExceptions) {
            builder.options(new Option[]{Option.SUPPRESS_EXCEPTIONS});
        }
        this.configuration = builder.build();
        boolean hasSimple = false;
        if (allowSimple && (matcher = SIMPLE_PATTERN.matcher(expression)).find()) {
            hasSimple = true;
        }
        if (hasSimple) {
            this.path = null;
        } else {
            this.path = JsonPath.compile((String)expression, (Predicate[])new Predicate[0]);
            LOG.debug("Compiled static JsonPath: {}", (Object)expression);
        }
    }

    public Object read(Exchange exchange) throws Exception {
        Object answer;
        if (this.path == null) {
            Expression exp = exchange.getContext().resolveLanguage("simple").createExpression(this.expression);
            String text = (String)exp.evaluate(exchange, String.class);
            JsonPath path = JsonPath.compile((String)text, (Predicate[])new Predicate[0]);
            LOG.debug("Compiled dynamic JsonPath: {}", (Object)this.expression);
            answer = this.doRead(path, exchange);
        } else {
            answer = this.doRead(this.path, exchange);
        }
        if (this.writeAsString) {
            if (!this.initJsonAdapter) {
                this.doInitAdapter(exchange);
            }
            if (this.adapter == null) {
                LOG.debug("Cannot writeAsString as adapter cannot be initialized");
                return answer;
            }
            if (answer instanceof Iterable) {
                ArrayList<String> list = new ArrayList<String>();
                Iterable it = (Iterable)answer;
                for (Object o : it) {
                    String json;
                    if (this.adapter == null || (json = this.adapter.writeAsString(o, exchange)) == null) continue;
                    list.add(json);
                }
                return list;
            }
            if (answer instanceof Map) {
                Map map = (Map)answer;
                for (Object key : map.keySet()) {
                    String json;
                    Object value = map.get(key);
                    if (this.adapter == null || (json = this.adapter.writeAsString(value, exchange)) == null) continue;
                    map.put(key, json);
                }
                return map;
            }
            String json = this.adapter.writeAsString(answer, exchange);
            if (json != null) {
                return json;
            }
        }
        return answer;
    }

    private Object doRead(JsonPath path, Exchange exchange) throws IOException, CamelExchangeException {
        Object json;
        Object object = json = this.headerName != null ? exchange.getIn().getHeader(this.headerName) : exchange.getIn().getBody();
        if (json instanceof InputStream) {
            return this.readWithInputStream(path, exchange);
        }
        if (json instanceof GenericFile) {
            LOG.trace("JSonPath: {} is read as generic file: {}", (Object)path, json);
            GenericFile genericFile = (GenericFile)json;
            if (genericFile.getCharset() != null) {
                FileInputStream inputStream = new FileInputStream((File)genericFile.getFile());
                return path.read((InputStream)inputStream, genericFile.getCharset(), this.configuration);
            }
        }
        if (json instanceof String) {
            LOG.trace("JSonPath: {} is read as String: {}", (Object)path, json);
            String str = (String)json;
            return path.read(str, this.configuration);
        }
        if (json instanceof Map) {
            LOG.trace("JSonPath: {} is read as Map: {}", (Object)path, json);
            Map map = (Map)json;
            return path.read((Object)map, this.configuration);
        }
        if (json instanceof List) {
            LOG.trace("JSonPath: {} is read as List: {}", (Object)path, json);
            List list = (List)json;
            return path.read((Object)list, this.configuration);
        }
        Object answer = this.readWithAdapter(path, exchange);
        if (answer == null) {
            answer = this.readWithInputStream(path, exchange);
        }
        if (answer != null) {
            return answer;
        }
        if (this.configuration.getOptions().contains(Option.SUPPRESS_EXCEPTIONS)) {
            if (this.configuration.getOptions().contains(Option.ALWAYS_RETURN_LIST)) {
                return Collections.emptyList();
            }
            return null;
        }
        if (this.headerName != null) {
            throw new CamelExchangeException("Cannot read message header " + this.headerName + " as supported JSON value", exchange);
        }
        throw new CamelExchangeException("Cannot read message body as supported JSON value", exchange);
    }

    private Object readWithInputStream(JsonPath path, Exchange exchange) throws IOException {
        Object json = this.headerName != null ? exchange.getIn().getHeader(this.headerName) : exchange.getIn().getBody();
        LOG.trace("JSonPath: {} is read as InputStream: {}", (Object)path, json);
        InputStream is = (InputStream)exchange.getContext().getTypeConverter().tryConvertTo(InputStream.class, exchange, json);
        if (json instanceof StreamCache) {
            ((StreamCache)json).reset();
        }
        if (is != null) {
            String jsonEncoding = (String)exchange.getIn().getHeader("CamelJsonPathJsonEncoding", String.class);
            if (jsonEncoding != null) {
                return path.read(is, jsonEncoding, this.configuration);
            }
            JsonStream jsonStream = new JsonStream(is);
            return path.read((InputStream)jsonStream, jsonStream.getEncoding().name(), this.configuration);
        }
        return null;
    }

    private Object readWithAdapter(JsonPath path, Exchange exchange) {
        Object json = this.headerName != null ? exchange.getIn().getHeader(this.headerName) : exchange.getIn().getBody();
        LOG.trace("JSonPath: {} is read with adapter: {}", (Object)path, json);
        this.doInitAdapter(exchange);
        if (this.adapter != null) {
            LOG.trace("Attempting to use JacksonJsonAdapter: {}", (Object)this.adapter);
            Map map = this.adapter.readValue(json, exchange);
            if (json instanceof StreamCache) {
                ((StreamCache)json).reset();
            }
            if (map != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("JacksonJsonAdapter converted object from: {} to: java.util.Map", (Object)ObjectHelper.classCanonicalName((Object)json));
                }
                return path.read((Object)map, this.configuration);
            }
        }
        return null;
    }

    private void doInitAdapter(Exchange exchange) {
        if (!this.initJsonAdapter) {
            try {
                Object obj;
                LOG.debug("Attempting to enable JacksonJsonAdapter by resolving: {} from classpath", (Object)JACKSON_JSON_ADAPTER);
                Class clazz = exchange.getContext().getClassResolver().resolveClass(JACKSON_JSON_ADAPTER);
                if (clazz != null && (obj = exchange.getContext().getInjector().newInstance(clazz)) instanceof JsonPathAdapter) {
                    this.adapter = (JsonPathAdapter)obj;
                    this.adapter.init(exchange.getContext());
                    LOG.debug("JacksonJsonAdapter found on classpath and enabled for camel-jsonpath: {}", (Object)this.adapter);
                }
            }
            catch (Throwable e) {
                LOG.debug("Cannot load org.apache.camel.jsonpath.jackson.JacksonJsonAdapter from classpath to enable JacksonJsonAdapter due " + e.getMessage() + ". JacksonJsonAdapter is not enabled.", e);
            }
            this.initJsonAdapter = true;
        }
    }
}

