/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class DataSetTestEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":name";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "dataset-test".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "name", null, true, copy);
        uri = this.buildQueryParameters(uri, copy);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return true;
    }

    static {
        HashSet<String> props = new HashSet<String>(18);
        props.add("basicPropertyBinding");
        props.add("synchronous");
        props.add("anyOrder");
        props.add("expectedCount");
        props.add("retainLast");
        props.add("assertPeriod");
        props.add("failFast");
        props.add("resultMinimumWaitTime");
        props.add("timeout");
        props.add("reportGroup");
        props.add("sleepForEmptyTest");
        props.add("lazyStartProducer");
        props.add("split");
        props.add("delimiter");
        props.add("name");
        props.add("copyOnExchange");
        props.add("resultWaitTime");
        props.add("retainFirst");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

