/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto.flow;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Date;
import org.apache.nifi.web.api.dto.flow.FlowDTO;
import org.apache.nifi.web.api.dto.util.TimeAdapter;
import org.apache.nifi.web.api.entity.FlowBreadcrumbEntity;
import org.apache.nifi.web.api.entity.ParameterContextReferenceEntity;

@XmlType(name="processGroupFlow")
public class ProcessGroupFlowDTO {
    private String id;
    private String uri;
    private String parentGroupId;
    private ParameterContextReferenceEntity parameterContext;
    private FlowBreadcrumbEntity breadcrumb;
    private FlowDTO flow;
    private Date lastRefreshed;

    @Schema(description="The flow structure starting at this Process Group.")
    public FlowDTO getFlow() {
        return this.flow;
    }

    public void setFlow(FlowDTO flow) {
        this.flow = flow;
    }

    @Schema(description="The id of the component.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Schema(description="The breadcrumb of the process group.")
    public FlowBreadcrumbEntity getBreadcrumb() {
        return this.breadcrumb;
    }

    public void setBreadcrumb(FlowBreadcrumbEntity breadcrumb) {
        this.breadcrumb = breadcrumb;
    }

    @Schema(description="The id of parent process group of this component if applicable.")
    public String getParentGroupId() {
        return this.parentGroupId;
    }

    public void setParentGroupId(String parentGroupId) {
        this.parentGroupId = parentGroupId;
    }

    @Schema(description="The URI for futures requests to the component.")
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @XmlJavaTypeAdapter(value=TimeAdapter.class)
    @Schema(description="The time the flow for the process group was last refreshed.", type="string")
    public Date getLastRefreshed() {
        return this.lastRefreshed;
    }

    public void setLastRefreshed(Date lastRefreshed) {
        this.lastRefreshed = lastRefreshed;
    }

    @Schema(description="The Parameter Context, or null if no Parameter Context has been bound to the Process Group")
    public ParameterContextReferenceEntity getParameterContext() {
        return this.parameterContext;
    }

    public void setParameterContext(ParameterContextReferenceEntity parameterContext) {
        this.parameterContext = parameterContext;
    }
}

