/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.client.impl;

import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.toolkit.client.ProcessGroupClient;
import org.apache.nifi.toolkit.client.RequestConfig;
import org.apache.nifi.toolkit.client.impl.AbstractJerseyClient;
import org.apache.nifi.web.api.entity.ControllerServiceEntity;
import org.apache.nifi.web.api.entity.CopyRequestEntity;
import org.apache.nifi.web.api.entity.CopyResponseEntity;
import org.apache.nifi.web.api.entity.CopySnippetRequestEntity;
import org.apache.nifi.web.api.entity.DropRequestEntity;
import org.apache.nifi.web.api.entity.FlowComparisonEntity;
import org.apache.nifi.web.api.entity.FlowEntity;
import org.apache.nifi.web.api.entity.PasteRequestEntity;
import org.apache.nifi.web.api.entity.PasteResponseEntity;
import org.apache.nifi.web.api.entity.ProcessGroupEntity;
import org.apache.nifi.web.api.entity.ProcessGroupImportEntity;
import org.apache.nifi.web.api.entity.ProcessGroupReplaceRequestEntity;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;

public class JerseyProcessGroupClient
extends AbstractJerseyClient
implements ProcessGroupClient {
    private final WebTarget processGroupsTarget;

    public JerseyProcessGroupClient(WebTarget baseTarget) {
        this(baseTarget, null);
    }

    public JerseyProcessGroupClient(WebTarget baseTarget, RequestConfig requestConfig) {
        super(requestConfig);
        this.processGroupsTarget = baseTarget.path("/process-groups");
    }

    @Override
    public ProcessGroupEntity createProcessGroup(String parentGroupdId, ProcessGroupEntity entity) throws NiFiClientException, IOException {
        return this.createProcessGroup(parentGroupdId, entity, true);
    }

    @Override
    public ProcessGroupEntity createProcessGroup(String parentGroupdId, ProcessGroupEntity entity, boolean keepExisting) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)parentGroupdId)) {
            throw new IllegalArgumentException("Parent process group id cannot be null or blank");
        }
        if (entity == null) {
            throw new IllegalArgumentException("Process group entity cannot be null");
        }
        return this.executeAction("Error creating process group", () -> {
            WebTarget target = this.processGroupsTarget.path("{id}/process-groups").queryParam("parameterContextHandlingStrategy", new Object[]{keepExisting ? "KEEP_EXISTING" : "REPLACE"}).resolveTemplate("id", (Object)parentGroupdId);
            return (ProcessGroupEntity)this.getRequestBuilder(target).post(Entity.entity((Object)entity, (MediaType)MediaType.APPLICATION_JSON_TYPE), ProcessGroupEntity.class);
        });
    }

    @Override
    public ProcessGroupEntity getProcessGroup(String processGroupId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)processGroupId)) {
            throw new IllegalArgumentException("Process group id cannot be null or blank");
        }
        return this.executeAction("Error getting process group", () -> {
            WebTarget target = this.processGroupsTarget.path("{id}").resolveTemplate("id", (Object)processGroupId);
            return (ProcessGroupEntity)this.getRequestBuilder(target).get(ProcessGroupEntity.class);
        });
    }

    @Override
    public ProcessGroupEntity updateProcessGroup(ProcessGroupEntity entity) throws NiFiClientException, IOException {
        if (entity == null) {
            throw new IllegalArgumentException("Process group entity cannot be null");
        }
        return this.executeAction("Error updating process group", () -> {
            WebTarget target = this.processGroupsTarget.path("{id}").resolveTemplate("id", (Object)entity.getId());
            return (ProcessGroupEntity)this.getRequestBuilder(target).put(Entity.entity((Object)entity, (MediaType)MediaType.APPLICATION_JSON_TYPE), ProcessGroupEntity.class);
        });
    }

    @Override
    public ProcessGroupEntity deleteProcessGroup(ProcessGroupEntity entity) throws NiFiClientException, IOException {
        if (entity == null) {
            throw new IllegalArgumentException("Process group entity cannot be null");
        }
        if (entity.getRevision() == null || entity.getRevision().getVersion() == null) {
            throw new IllegalArgumentException("Process group revision cannot be null");
        }
        return this.executeAction("Error deleting process group", () -> {
            WebTarget target = this.processGroupsTarget.path("{id}").resolveTemplate("id", (Object)entity.getId()).queryParam("version", new Object[]{entity.getRevision().getVersion()});
            if (entity.isDisconnectedNodeAcknowledged() == Boolean.TRUE) {
                target = target.queryParam("disconnectedNodeAcknowledged", new Object[]{"true"});
            }
            return (ProcessGroupEntity)this.getRequestBuilder(target).delete(ProcessGroupEntity.class);
        });
    }

    @Override
    public ControllerServiceEntity createControllerService(String processGroupId, ControllerServiceEntity controllerService) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)processGroupId)) {
            throw new IllegalArgumentException("Process group id cannot be null or blank");
        }
        if (controllerService == null) {
            throw new IllegalArgumentException("Controller service entity cannot be null");
        }
        return this.executeAction("Error creating controller service", () -> {
            WebTarget target = this.processGroupsTarget.path("{id}/controller-services").resolveTemplate("id", (Object)processGroupId);
            return (ControllerServiceEntity)this.getRequestBuilder(target).post(Entity.entity((Object)controllerService, (String)"application/json"), ControllerServiceEntity.class);
        });
    }

    @Override
    public ProcessGroupReplaceRequestEntity replaceProcessGroup(String processGroupId, ProcessGroupImportEntity importEntity) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)processGroupId)) {
            throw new IllegalArgumentException("Process group id cannot be null or blank");
        }
        if (importEntity == null || importEntity.getVersionedFlowSnapshot() == null) {
            throw new IllegalArgumentException("ProcessGroupImportEntity cannot be null and must have a non-null VersionedFlowSnapshot");
        }
        return this.executeAction("Error creating process group replacement request", () -> {
            WebTarget target = this.processGroupsTarget.path("{processGroupId}/replace-requests").resolveTemplate("processGroupId", (Object)processGroupId);
            return (ProcessGroupReplaceRequestEntity)this.getRequestBuilder(target).post(Entity.entity((Object)importEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), ProcessGroupReplaceRequestEntity.class);
        });
    }

    @Override
    public ProcessGroupReplaceRequestEntity getProcessGroupReplaceRequest(String processGroupId, String requestId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)processGroupId)) {
            throw new IllegalArgumentException("Process group id cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)requestId)) {
            throw new IllegalArgumentException("Request id cannot be null or blank");
        }
        return this.executeAction("Error getting process group replacement request", () -> {
            WebTarget target = this.processGroupsTarget.path("replace-requests/{requestId}").resolveTemplate("requestId", (Object)requestId);
            return (ProcessGroupReplaceRequestEntity)this.getRequestBuilder(target).get(ProcessGroupReplaceRequestEntity.class);
        });
    }

    @Override
    public ProcessGroupReplaceRequestEntity deleteProcessGroupReplaceRequest(String processGroupId, String requestId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)processGroupId)) {
            throw new IllegalArgumentException("Process group id cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)requestId)) {
            throw new IllegalArgumentException("Request id cannot be null or blank");
        }
        return this.executeAction("Error deleting process group replacement request", () -> {
            WebTarget target = this.processGroupsTarget.path("replace-requests/{requestId}").resolveTemplate("requestId", (Object)requestId);
            return (ProcessGroupReplaceRequestEntity)this.getRequestBuilder(target).delete(ProcessGroupReplaceRequestEntity.class);
        });
    }

    @Override
    public FlowEntity copySnippet(String processGroupId, CopySnippetRequestEntity copySnippetRequestEntity) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)processGroupId)) {
            throw new IllegalArgumentException("Process group id cannot be null or blank");
        }
        if (copySnippetRequestEntity == null) {
            throw new IllegalArgumentException("Snippet Request Entity cannot be null");
        }
        return this.executeAction("Error copying snippet to Process Group", () -> {
            WebTarget target = this.processGroupsTarget.path("{id}/snippet-instance").resolveTemplate("id", (Object)processGroupId);
            return (FlowEntity)this.getRequestBuilder(target).post(Entity.entity((Object)copySnippetRequestEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), FlowEntity.class);
        });
    }

    @Override
    public FlowComparisonEntity getLocalModifications(String processGroupId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)processGroupId)) {
            throw new IllegalArgumentException("Process group id cannot be null or blank");
        }
        return this.executeAction("Error retrieving list of local flow modifications", () -> {
            WebTarget target = this.processGroupsTarget.path("{id}/local-modifications").resolveTemplate("id", (Object)processGroupId);
            return (FlowComparisonEntity)this.getRequestBuilder(target).get(FlowComparisonEntity.class);
        });
    }

    @Override
    public File exportProcessGroup(String processGroupId, boolean includeReferencedServices, File outputFile) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)processGroupId)) {
            throw new IllegalArgumentException("Process group id cannot be null or blank");
        }
        return this.executeAction("Error getting process group", () -> {
            WebTarget target = this.processGroupsTarget.path("{id}/download").resolveTemplate("id", (Object)processGroupId).queryParam("includeReferencedServices", new Object[]{includeReferencedServices});
            Response response = this.getRequestBuilder(target).accept(new String[]{"application/json"}).get();
            return this.getFileContent(response, outputFile);
        });
    }

    @Override
    public DropRequestEntity emptyQueues(String processGroupId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)processGroupId)) {
            throw new IllegalArgumentException("Process group id cannot be null or blank");
        }
        return this.executeAction("Error emptying queues in Process Group", () -> {
            WebTarget target = this.processGroupsTarget.path("{id}/empty-all-connections-requests").resolveTemplate("id", (Object)processGroupId);
            return (DropRequestEntity)this.getRequestBuilder(target).post(null, DropRequestEntity.class);
        });
    }

    @Override
    public DropRequestEntity getEmptyQueuesRequest(String processGroupId, String requestId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)processGroupId)) {
            throw new IllegalArgumentException("Process group id cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)requestId)) {
            throw new IllegalArgumentException("Request id cannot be null or blank");
        }
        return this.executeAction("Error getting Drop Request status for Process Group", () -> {
            WebTarget target = this.processGroupsTarget.path("{id}/empty-all-connections-requests/{drop-request-id}").resolveTemplate("id", (Object)processGroupId).resolveTemplate("drop-request-id", (Object)requestId);
            return (DropRequestEntity)this.getRequestBuilder(target).get(DropRequestEntity.class);
        });
    }

    private File getFileContent(Response response, File outputFile) {
        File file;
        block9: {
            String contentDispositionHeader = response.getHeaderString("Content-Disposition");
            if (StringUtils.isBlank((CharSequence)contentDispositionHeader)) {
                throw new IllegalStateException("Content-Disposition header was blank or missing");
            }
            InputStream responseInputStream = (InputStream)response.readEntity(InputStream.class);
            try {
                Files.copy(responseInputStream, outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                file = outputFile;
                if (responseInputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (responseInputStream != null) {
                        try {
                            responseInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Unable to write content due to: " + e.getMessage(), e);
                }
            }
            responseInputStream.close();
        }
        return file;
    }

    @Override
    public CopyResponseEntity copy(String processGroupId, CopyRequestEntity copyRequestEntity) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)processGroupId)) {
            throw new IllegalArgumentException("Process group id cannot be null or blank");
        }
        if (copyRequestEntity == null) {
            throw new IllegalArgumentException("Copy Request Entity cannot be null");
        }
        return this.executeAction("Error copying", () -> {
            WebTarget target = this.processGroupsTarget.path("{id}/copy").resolveTemplate("id", (Object)processGroupId);
            return (CopyResponseEntity)this.getRequestBuilder(target).post(Entity.entity((Object)copyRequestEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), CopyResponseEntity.class);
        });
    }

    @Override
    public PasteResponseEntity paste(String processGroupId, PasteRequestEntity pasteRequestEntity) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)processGroupId)) {
            throw new IllegalArgumentException("Process group id cannot be null or blank");
        }
        if (pasteRequestEntity == null) {
            throw new IllegalArgumentException("Paste Request Entity cannot be null");
        }
        return this.executeAction("Error pasting", () -> {
            WebTarget target = this.processGroupsTarget.path("{id}/paste").resolveTemplate("id", (Object)processGroupId);
            return (PasteResponseEntity)this.getRequestBuilder(target).put(Entity.entity((Object)pasteRequestEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), PasteResponseEntity.class);
        });
    }

    @Override
    public ProcessGroupEntity upload(String parentPgId, File file, String pgName, Double posX, Double posY) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)parentPgId)) {
            throw new IllegalArgumentException("Parent process group id cannot be null or blank");
        }
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        if (!file.exists() || !file.canRead()) {
            throw new IllegalArgumentException("Specified file is not a local readable file: " + file.getAbsolutePath());
        }
        FormDataMultiPart form = new FormDataMultiPart();
        form.field("id", parentPgId);
        form.field("groupName", pgName);
        form.field("positionX", Double.toString(posX));
        form.field("positionY", Double.toString(posY));
        form.field("clientId", UUID.randomUUID().toString());
        form.bodyPart((BodyPart)new FileDataBodyPart("file", file, MediaType.APPLICATION_JSON_TYPE));
        return this.executeAction("Error uploading process group", () -> {
            WebTarget target = this.processGroupsTarget.path("{id}/process-groups/upload").resolveTemplate("id", (Object)parentPgId);
            return (ProcessGroupEntity)this.getRequestBuilder(target).post(Entity.entity((Object)form, (String)"multipart/form-data"), ProcessGroupEntity.class);
        });
    }
}

