<!--
  Licensed to the Apache Software Foundation (ASF) under one or more
  contributor license agreements.  See the NOTICE file distributed with
  this work for additional information regarding copyright ownership.
  The ASF licenses this file to You under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with
  the License.  You may obtain a copy of the License at
      http://www.apache.org/licenses/LICENSE-2.0
  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
-->

Apache NiFi supports powerful and scalable directed graphs of data routing, transformation, and system mediation logic. Some of the high-level capabilities and objectives of Apache NiFi include:

* Web-based user interface
  * Seamless experience between design, control, feedback, and monitoring
* Highly configurable
  * Loss tolerant vs guaranteed delivery
  * Low latency vs high throughput
  * Dynamic prioritization
  * Flow can be modified at runtime
  * Back pressure
* Data Provenance
  * Track dataflow from beginning to end
* Designed for extension
  * Build your own processors and more
  * Enables rapid development and effective testing
* Secure
  * SSL, SSH, HTTPS, encrypted content, etc...
  * Multi-tenant authorization and internal authorization/policy management
