/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.metrics;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.incubator.metrics.ExtendedLongUpDownCounterBuilder;
import io.opentelemetry.api.metrics.LongUpDownCounter;
import io.opentelemetry.api.metrics.LongUpDownCounterBuilder;
import io.opentelemetry.api.metrics.Meter;
import org.apache.pulsar.client.impl.metrics.MetricsUtil;
import org.apache.pulsar.client.impl.metrics.Unit;

public class UpDownCounter {
    private final LongUpDownCounter counter;
    private final Attributes attributes;

    UpDownCounter(Meter meter, String name, Unit unit, String description, String topic, Attributes attributes) {
        LongUpDownCounterBuilder builder = meter.upDownCounterBuilder(name).setDescription(description).setUnit(unit.toString());
        if (topic != null) {
            if (builder instanceof ExtendedLongUpDownCounterBuilder) {
                ExtendedLongUpDownCounterBuilder eb = (ExtendedLongUpDownCounterBuilder)builder;
                eb.setAttributesAdvice(MetricsUtil.getDefaultAggregationLabels(attributes));
            }
            attributes = MetricsUtil.getTopicAttributes(topic, attributes);
        }
        this.counter = builder.build();
        this.attributes = attributes;
    }

    public void increment() {
        this.add(1L);
    }

    public void decrement() {
        this.add(-1L);
    }

    public void add(long delta) {
        this.counter.add(delta, this.attributes);
    }

    public void subtract(long diff) {
        this.add(-diff);
    }
}

