/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers.slinginitialcontent;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.function.IOSupplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.util.PlatformNameFormat;
import org.apache.sling.feature.cpconverter.ConverterException;
import org.apache.sling.feature.cpconverter.handlers.slinginitialcontent.AssemblerProvider;
import org.apache.sling.feature.cpconverter.handlers.slinginitialcontent.BundleSlingInitialContentExtractContext;
import org.apache.sling.feature.cpconverter.handlers.slinginitialcontent.ContentReaderProvider;
import org.apache.sling.feature.cpconverter.handlers.slinginitialcontent.ParentFolderRepoInitHandler;
import org.apache.sling.feature.cpconverter.handlers.slinginitialcontent.SlingInitialContentBundleEntryMetaData;
import org.apache.sling.feature.cpconverter.handlers.slinginitialcontent.VaultContentXMLContentCreator;
import org.apache.sling.feature.cpconverter.vltpkg.SingleFileArchive;
import org.apache.sling.feature.cpconverter.vltpkg.VaultPackageAssembler;
import org.apache.sling.jcr.contentloader.ContentCreator;
import org.apache.sling.jcr.contentloader.ContentReader;
import org.apache.sling.jcr.contentloader.PathEntry;
import org.jetbrains.annotations.NotNull;

class BundleSlingInitialContentJarEntryExtractor {
    private final AssemblerProvider assemblerProvider;
    private final ContentReaderProvider contentReaderProvider;
    private final ParentFolderRepoInitHandler parentFolderRepoInitHandler;

    BundleSlingInitialContentJarEntryExtractor(@NotNull AssemblerProvider assemblerProvider, @NotNull ContentReaderProvider contentReaderProvider, @NotNull ParentFolderRepoInitHandler parentFolderRepoInitHandler) {
        this.assemblerProvider = assemblerProvider;
        this.contentReaderProvider = contentReaderProvider;
        this.parentFolderRepoInitHandler = parentFolderRepoInitHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void extractAndAddToAssembler(@NotNull BundleSlingInitialContentExtractContext context, @NotNull SlingInitialContentBundleEntryMetaData slingInitialContentBundleEntryMetaData, @NotNull Set<SlingInitialContentBundleEntryMetaData> collectedSlingInitialContentBundleEntries) throws IOException, ConverterException {
        String repositoryPath = slingInitialContentBundleEntryMetaData.getRepositoryPath();
        File file = slingInitialContentBundleEntryMetaData.getSourceFile();
        PathEntry pathEntryValue = slingInitialContentBundleEntryMetaData.getPathEntry();
        String contentPackageEntryPath = "/jcr_root" + PlatformNameFormat.getPlatformPath((String)repositoryPath);
        Path tmpDocViewInputFile = null;
        try {
            try (FileInputStream bundleFileInputStream = new FileInputStream(file);){
                VaultPackageAssembler packageAssembler = this.assemblerProvider.initPackageAssemblerForPath(context, repositoryPath, pathEntryValue);
                ContentReader contentReader = this.contentReaderProvider.getContentReaderForEntry(file, pathEntryValue);
                if (contentReader != null) {
                    tmpDocViewInputFile = Files.createTempFile(context.getConverter().getTempDirectory().toPath(), "docview", ".xml", new FileAttribute[0]);
                    try (OutputStream docViewOutput = Files.newOutputStream(tmpDocViewInputFile, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
                        repositoryPath = FilenameUtils.removeExtension((String)repositoryPath);
                        boolean isFileDescriptorEntry = this.isFileDescriptor(collectedSlingInitialContentBundleEntries, contentPackageEntryPath);
                        VaultContentXMLContentCreator contentCreator = new VaultContentXMLContentCreator(repositoryPath, docViewOutput, context.getNamespaceRegistry(), packageAssembler, isFileDescriptorEntry);
                        contentReader.parse(file.toURI().toURL(), (ContentCreator)contentCreator);
                        contentCreator.finish();
                        contentPackageEntryPath = contentCreator.getContentPackageEntryPath();
                    }
                    catch (IOException e) {
                        throw new IOException("Can not parse " + file, e);
                    }
                    catch (RepositoryException e) {
                        throw new IOException("Can not convert " + file + " to enhanced DocView format", e);
                    }
                    if (context.getNamespaceRegistry().getRegisteredCndSystemIds().contains(file.getName())) {
                        contentPackageEntryPath = "/META-INF/vault/" + Text.getName((String)file.getName()) + ".cnd";
                    }
                }
                try (SingleFileArchive virtualArchive = SingleFileArchive.fromPathOrInputStream(tmpDocViewInputFile, bundleFileInputStream, (IOSupplier<Path>)((IOSupplier)() -> Files.createTempFile(context.getConverter().getTempDirectory().toPath(), "initial-content", Text.getName((String)file.getName()), new FileAttribute[0])), contentPackageEntryPath);){
                    if (tmpDocViewInputFile != null) {
                        packageAssembler.addEntry(contentPackageEntryPath, tmpDocViewInputFile.toFile());
                    } else {
                        packageAssembler.addEntry(contentPackageEntryPath, bundleFileInputStream);
                    }
                    this.parentFolderRepoInitHandler.addParentsForPath(contentPackageEntryPath);
                }
            }
            if (tmpDocViewInputFile == null) return;
        }
        catch (Throwable throwable) {
            if (tmpDocViewInputFile == null) throw throwable;
            Files.delete(tmpDocViewInputFile);
            throw throwable;
        }
        Files.delete(tmpDocViewInputFile);
    }

    private boolean isFileDescriptor(@NotNull Set<SlingInitialContentBundleEntryMetaData> bundleEntries, @NotNull String contentPackageEntryPath) {
        String recomputedContentPackageEntryPath = FilenameUtils.removeExtension((String)contentPackageEntryPath);
        String checkIfRecomputedPathCandidate = StringUtils.removeStart((String)recomputedContentPackageEntryPath, (String)"/jcr_root");
        return bundleEntries.stream().anyMatch(bundleEntry -> StringUtils.equals((CharSequence)checkIfRecomputedPathCandidate, (CharSequence)bundleEntry.getRepositoryPath()));
    }
}

