/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.interceptor;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.struts2.ActionContext;
import org.apache.struts2.ActionInvocation;
import org.apache.struts2.conversion.impl.ConversionData;
import org.apache.struts2.conversion.impl.XWorkConverter;
import org.apache.struts2.interceptor.MethodFilterInterceptor;
import org.apache.struts2.interceptor.ValidationAware;
import org.apache.struts2.util.ValueStack;

public class ConversionErrorInterceptor
extends MethodFilterInterceptor {
    public static final String ORIGINAL_PROPERTY_OVERRIDE = "original.property.override";

    protected Object getOverrideExpr(ActionInvocation invocation, Object value) {
        return this.escape(value);
    }

    protected String escape(Object value) {
        return "\"" + StringEscapeUtils.escapeJava((String)String.valueOf(value)) + "\"";
    }

    @Override
    public String doIntercept(ActionInvocation invocation) throws Exception {
        ActionContext invocationContext = invocation.getInvocationContext();
        Map<String, ConversionData> conversionErrors = invocationContext.getConversionErrors();
        ValueStack stack = invocationContext.getValueStack();
        HashMap<String, Object> fakie = null;
        for (Map.Entry<String, ConversionData> entry : conversionErrors.entrySet()) {
            ConversionData conversionData;
            String propertyName = entry.getKey();
            if (!this.shouldAddError(propertyName, (conversionData = entry.getValue()).getValue())) continue;
            String message = XWorkConverter.getConversionErrorMessage(propertyName, conversionData.getToClass(), stack);
            Object action = invocation.getAction();
            if (action instanceof ValidationAware) {
                ValidationAware va = (ValidationAware)action;
                va.addFieldError(propertyName, message);
            }
            if (fakie == null) {
                fakie = new HashMap<String, Object>();
            }
            fakie.put(propertyName, this.getOverrideExpr(invocation, conversionData.getValue()));
        }
        if (fakie != null) {
            stack.getContext().put(ORIGINAL_PROPERTY_OVERRIDE, fakie);
            invocation.addPreResultListener((invocation1, resultCode) -> {
                Map fakie1 = (Map)invocation1.getInvocationContext().get(ORIGINAL_PROPERTY_OVERRIDE);
                if (fakie1 != null) {
                    invocation1.getStack().setExprOverrides(fakie1);
                }
            });
        }
        return invocation.invoke();
    }

    protected boolean shouldAddError(String propertyName, Object value) {
        return true;
    }
}

