/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill.events;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sf.jasperreports.engine.fill.JRFillContext;
import net.sf.jasperreports.engine.fill.events.ListenerRegistry;
import net.sf.jasperreports.engine.fill.events.RegisteredListener;
import net.sf.jasperreports.engine.fill.events.ReportEventListener;
import net.sf.jasperreports.engine.fill.events.ReportFillEvent;
import net.sf.jasperreports.engine.fill.events.ReportFillListenerProvider;

public class FillEvents {
    private final ListenerRegistry<ReportFillEvent> listeners;

    public FillEvents(JRFillContext fillContext) {
        List fillListeners = this.collectFillListeners(fillContext);
        this.listeners = fillListeners.isEmpty() ? null : new ListenerRegistry(fillListeners);
    }

    private List<RegisteredListener<ReportFillEvent>> collectFillListeners(JRFillContext fillContext) {
        List<ReportFillListenerProvider> providers = fillContext.getMasterFiller().getJasperReportsContext().getExtensions(ReportFillListenerProvider.class);
        return providers.stream().flatMap(provider -> {
            final Stream.Builder builder = Stream.builder();
            provider.produce(fillContext, new ReportFillListenerProvider.ListenerConsumer(){

                @Override
                public <T extends ReportFillEvent> void accept(Class<T> eventType, ReportEventListener<? super T> listener) {
                    builder.accept(new RegisteredListener<T>(eventType, listener));
                }
            });
            return builder.build();
        }).collect(Collectors.toList());
    }

    public <T extends ReportFillEvent> void triggerEvent(Class<T> eventType, Supplier<T> eventSupplier) {
        if (this.listeners != null) {
            this.listeners.triggerEvent(eventType, eventSupplier);
        }
    }
}

