/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;

public class Graph<V extends Comparable<V>> {
    private final SortedMap<V, SortedMap<V, Edge>> adjList = new TreeMap(Comparator.nullsFirst(Comparator.naturalOrder()));
    private final SortedSet<V> nodes = new TreeSet(Comparator.nullsFirst(Comparator.naturalOrder()));
    private final boolean isResidualGraph;
    private V sourceNode;
    private V sinkNode;

    public Graph() {
        this(false);
    }

    private Graph(boolean isResidualGraph) {
        this.isResidualGraph = isResidualGraph;
    }

    public void addEdge(V u, V v, int capacity, int cost, int flow) {
        Objects.requireNonNull(u);
        Objects.requireNonNull(v);
        this.addEdge(u, new Edge(this, v, capacity, cost, capacity - flow, flow));
    }

    public SortedSet<V> nodes() {
        return this.nodes;
    }

    public SortedMap<V, Edge> edges(V node) {
        SortedMap edge = (SortedMap)this.adjList.get(node);
        return edge == null ? new TreeMap() : edge;
    }

    public boolean isResidualGraph() {
        return this.isResidualGraph;
    }

    public void setSourceNode(V node) {
        this.sourceNode = node;
    }

    public void setSinkNode(V node) {
        this.sinkNode = node;
    }

    public long totalCost() {
        long totalCost = 0L;
        for (Map.Entry<V, SortedMap<V, Edge>> nodeEdges : this.adjList.entrySet()) {
            SortedMap<V, Edge> edges = nodeEdges.getValue();
            for (Edge nodeEdge : edges.values()) {
                totalCost += (long)nodeEdge.cost * (long)nodeEdge.flow;
            }
        }
        return totalCost;
    }

    private void addEdge(V u, Edge edge) {
        Map edgeMap;
        if (!this.isResidualGraph && (edgeMap = (Map)this.adjList.get(edge.destination)) != null && edgeMap.containsKey(u)) {
            throw new IllegalArgumentException("There is already an edge from " + edge.destination + " to " + u + ". Can not add an edge from " + u + " to " + edge.destination + " since there will create a cycle between two nodes");
        }
        this.adjList.computeIfAbsent((SortedMap)u, (Function<SortedMap, SortedMap<SortedMap, Edge>>)((Function<Comparable, SortedMap>)set -> new TreeMap())).put(edge.destination, edge);
        this.nodes.add(u);
        this.nodes.add(edge.destination);
    }

    public Graph<V> residualGraph() {
        if (this.isResidualGraph) {
            return this;
        }
        Graph<V> residualGraph = new Graph<V>(true);
        for (Map.Entry<V, SortedMap<V, Edge>> nodeEdges : this.adjList.entrySet()) {
            Comparable node = (Comparable)nodeEdges.getKey();
            SortedMap<V, Edge> edges = nodeEdges.getValue();
            for (Map.Entry<V, Edge> nodeEdge : edges.entrySet()) {
                Edge backwardEdge;
                Edge edge = nodeEdge.getValue();
                Edge forwardEdge = new Edge(this, edge.destination, edge.capacity, edge.cost, edge.capacity - edge.flow, edge.flow);
                forwardEdge.counterEdge = backwardEdge = new Edge(this, node, edge.capacity, edge.cost * -1, edge.flow, 0, false);
                backwardEdge.counterEdge = forwardEdge;
                super.addEdge(node, forwardEdge);
                super.addEdge(edge.destination, backwardEdge);
            }
        }
        residualGraph.setSourceNode(this.sourceNode);
        residualGraph.setSinkNode(this.sinkNode);
        return residualGraph;
    }

    private void addDummySourceNode(Graph<V> residualGraph) {
        if (!residualGraph.isResidualGraph) {
            throw new IllegalStateException("Graph should be residual graph to add dummy source node");
        }
        TreeMap<Comparable, Edge> destMap = new TreeMap<Comparable, Edge>();
        for (Comparable node : residualGraph.nodes) {
            Edge edge = new Edge(this, node, 1, 0, 1, 0);
            destMap.put(node, edge);
        }
        residualGraph.adjList.put(null, destMap);
        residualGraph.nodes.add(null);
    }

    private void removeDummySourceNode(Graph<V> residualGraph) {
        if (!residualGraph.isResidualGraph) {
            throw new IllegalStateException("Graph should be residual graph to remove dummy source node");
        }
        residualGraph.adjList.remove(null);
        residualGraph.nodes.remove(null);
    }

    public void solveMinCostFlow() {
        this.validateMinCostGraph();
        Graph<V> residualGraph = this.residualGraph();
        this.addDummySourceNode(residualGraph);
        super.cancelNegativeCycles();
        this.removeDummySourceNode(residualGraph);
        for (Map.Entry<V, SortedMap<V, Edge>> nodeEdges : this.adjList.entrySet()) {
            Comparable node = (Comparable)nodeEdges.getKey();
            for (Map.Entry<V, Edge> nodeEdge : nodeEdges.getValue().entrySet()) {
                Comparable destination = (Comparable)nodeEdge.getKey();
                Edge edge = nodeEdge.getValue();
                Edge residualEdge = (Edge)((SortedMap)residualGraph.adjList.get(node)).get(destination);
                edge.flow = residualEdge.flow;
                edge.residualFlow = residualEdge.residualFlow;
            }
        }
    }

    public long flow() {
        long flow = 0L;
        SortedMap edges = (SortedMap)this.adjList.get(this.sourceNode);
        if (edges != null) {
            for (Edge edge : edges.values()) {
                flow += (long)edge.flow;
            }
        }
        return flow;
    }

    public long calculateMaxFlow() {
        Graph<V> residualGraph = this.residualGraph();
        super.fordFulkson();
        long maxFlow = 0L;
        for (Map.Entry<V, SortedMap<V, Edge>> nodeEdges : this.adjList.entrySet()) {
            Comparable node = (Comparable)nodeEdges.getKey();
            for (Map.Entry<V, Edge> nodeEdge : nodeEdges.getValue().entrySet()) {
                Comparable destination = (Comparable)nodeEdge.getKey();
                Edge edge = nodeEdge.getValue();
                Edge residualEdge = (Edge)((SortedMap)residualGraph.adjList.get(node)).get(destination);
                edge.flow = residualEdge.flow;
                edge.residualFlow = residualEdge.residualFlow;
                if (node != this.sourceNode) continue;
                maxFlow += (long)edge.flow;
            }
        }
        return maxFlow;
    }

    private void fordFulkson() {
        if (!this.isResidualGraph) {
            throw new IllegalStateException("Should be residual graph to cancel negative cycles");
        }
        HashMap parents = new HashMap();
        while (this.breadthFirstSearch(this.sourceNode, this.sinkNode, parents)) {
            Comparable parent;
            int possibleFlow = Integer.MAX_VALUE;
            Object node = this.sinkNode;
            while (node != this.sourceNode) {
                parent = (Comparable)parents.get(node);
                possibleFlow = Math.min(possibleFlow, ((Edge)((SortedMap)this.adjList.get((Object)parent)).get(node)).residualFlow);
                node = (Comparable)parents.get(node);
            }
            node = this.sinkNode;
            while (node != this.sourceNode) {
                parent = (Comparable)parents.get(node);
                Edge parentEdge = (Edge)((SortedMap)this.adjList.get(parent)).get(node);
                Edge counterEdge = parentEdge.counterEdge;
                parentEdge.residualFlow -= possibleFlow;
                if (parentEdge.forwardEdge) {
                    parentEdge.flow += possibleFlow;
                }
                counterEdge.residualFlow += possibleFlow;
                if (counterEdge.forwardEdge && counterEdge.flow >= possibleFlow) {
                    counterEdge.flow -= possibleFlow;
                }
                node = (Comparable)parents.get(node);
            }
            parents = new HashMap();
        }
    }

    private boolean breadthFirstSearch(V source, V target, Map<V, V> parents) {
        HashSet<Object> visited = new HashSet<Object>();
        LinkedList<Object> queue = new LinkedList<Object>();
        queue.add(source);
        visited.add(source);
        while (!queue.isEmpty()) {
            Comparable node = (Comparable)queue.poll();
            SortedMap nodeEdges = (SortedMap)this.adjList.get(node);
            for (Map.Entry nodeEdge : nodeEdges.entrySet()) {
                Comparable nextNode = (Comparable)nodeEdge.getKey();
                if (visited.contains(nextNode) || ((Edge)nodeEdge.getValue()).residualFlow <= 0) continue;
                if (((Comparable)nodeEdge.getKey()).equals(target)) {
                    parents.put((Comparable)target, node);
                    return true;
                }
                queue.add(nodeEdge.getKey());
                parents.put((Comparable)nodeEdge.getKey(), node);
                visited.add(nodeEdge.getKey());
            }
        }
        return false;
    }

    private void populateInOutFlow(Map<V, Long> inFlow, Map<V, Long> outFlow) {
        for (Map.Entry<V, SortedMap<V, Edge>> nodeEdges : this.adjList.entrySet()) {
            Comparable node = (Comparable)nodeEdges.getKey();
            if (node.equals(this.sinkNode)) {
                throw new IllegalStateException("Sink node " + this.sinkNode + " shouldn't have output");
            }
            for (Map.Entry<V, Edge> nodeEdge : nodeEdges.getValue().entrySet()) {
                Comparable destination = (Comparable)nodeEdge.getKey();
                if (destination.equals(this.sourceNode)) {
                    throw new IllegalStateException("Source node " + this.sourceNode + " shouldn't have input " + node);
                }
                Edge edge = nodeEdge.getValue();
                Long count = outFlow.get(node);
                if (count == null) {
                    outFlow.put((Long)node, Long.valueOf(edge.flow));
                } else {
                    outFlow.put((Long)node, count + (long)edge.flow);
                }
                count = inFlow.get(destination);
                if (count == null) {
                    inFlow.put((Long)destination, Long.valueOf(edge.flow));
                    continue;
                }
                inFlow.put((Long)destination, count + (long)edge.flow);
            }
        }
    }

    private void validateMinCostGraph() {
        Long sinkInput;
        if (this.isResidualGraph) {
            throw new IllegalStateException("Should not be residual graph to solve min cost flow");
        }
        HashMap inFlow = new HashMap();
        HashMap outFlow = new HashMap();
        this.populateInOutFlow(inFlow, outFlow);
        for (Map.Entry in : inFlow.entrySet()) {
            if (((Comparable)in.getKey()).equals(this.sourceNode) || ((Comparable)in.getKey()).equals(this.sinkNode)) continue;
            Long out = (Long)outFlow.get(in.getKey());
            if (Objects.equals(in.getValue(), out)) continue;
            throw new IllegalStateException("Input flow for node " + in.getKey() + " is " + in.getValue() + " which doesn't match output flow " + out);
        }
        Long sourceOutput = (Long)outFlow.get(this.sourceNode);
        if (!Objects.equals(sourceOutput, sinkInput = (Long)inFlow.get(this.sinkNode))) {
            throw new IllegalStateException("Output flow for source " + this.sourceNode + " is " + sourceOutput + " which doesn't match input flow " + sinkInput + " for sink " + this.sinkNode);
        }
    }

    private void cancelNegativeCycles() {
        if (!this.isResidualGraph) {
            throw new IllegalStateException("Should be residual graph to cancel negative cycles");
        }
        boolean cyclePossible = true;
        while (cyclePossible) {
            cyclePossible = false;
            HashMap parentNodes = new HashMap();
            HashMap parentEdges = new HashMap();
            Comparable possibleNodeInCycle = this.detectNegativeCycles(null, parentNodes, parentEdges);
            if (possibleNodeInCycle == null) continue;
            HashSet<Comparable> visited = new HashSet<Comparable>();
            Comparable nodeInCycle = possibleNodeInCycle;
            while (!visited.contains(nodeInCycle)) {
                visited.add(nodeInCycle);
                nodeInCycle = (Comparable)parentNodes.get(nodeInCycle);
            }
            cyclePossible = true;
            this.cancelNegativeCycle(nodeInCycle, parentNodes, parentEdges);
        }
    }

    private void cancelNegativeCycle(V nodeInCycle, Map<V, V> parentNodes, Map<V, Edge> parentEdges) {
        Comparable parentNode = (Comparable)parentNodes.get(nodeInCycle);
        Edge parentEdge = parentEdges.get(nodeInCycle);
        int possibleFlow = parentEdge.residualFlow;
        Comparable curNode = parentNode;
        while (curNode != nodeInCycle) {
            parentEdge = parentEdges.get(curNode);
            possibleFlow = Math.min(possibleFlow, parentEdge.residualFlow);
            curNode = (Comparable)parentNodes.get(curNode);
        }
        parentEdge = parentEdges.get(nodeInCycle);
        Edge counterEdge = parentEdge.counterEdge;
        parentEdge.residualFlow -= possibleFlow;
        if (parentEdge.forwardEdge) {
            parentEdge.flow += possibleFlow;
        }
        counterEdge.residualFlow += possibleFlow;
        if (counterEdge.forwardEdge && counterEdge.flow >= possibleFlow) {
            counterEdge.flow -= possibleFlow;
        }
        Comparable curNode2 = parentNode;
        while (curNode2 != nodeInCycle) {
            parentEdge = parentEdges.get(curNode2);
            counterEdge = parentEdge.counterEdge;
            parentEdge.residualFlow -= possibleFlow;
            if (parentEdge.forwardEdge) {
                parentEdge.flow += possibleFlow;
            }
            counterEdge.residualFlow += possibleFlow;
            if (counterEdge.forwardEdge && counterEdge.flow >= possibleFlow) {
                counterEdge.flow -= possibleFlow;
            }
            curNode2 = (Comparable)parentNodes.get(curNode2);
        }
    }

    V detectNegativeCycles(V source, Map<V, V> parentNodes, Map<V, Edge> parentEdges) {
        HashMap distance = new HashMap();
        distance.put(source, 0L);
        int nodeCount = this.nodes.size();
        for (int i = 0; i < nodeCount; ++i) {
            for (Map.Entry<V, SortedMap<V, Edge>> nodeEdges : this.adjList.entrySet()) {
                Comparable start = (Comparable)nodeEdges.getKey();
                for (Map.Entry<V, Edge> nodeEdge : nodeEdges.getValue().entrySet()) {
                    Edge edge = nodeEdge.getValue();
                    if (edge.residualFlow == 0) continue;
                    Object end = edge.destination;
                    Long distanceStart = (Long)distance.get(start);
                    Long distanceEnd = (Long)distance.get(end);
                    if (distanceStart == null || distanceEnd != null && distanceEnd <= distanceStart + (long)edge.cost) continue;
                    distance.put(end, distanceStart + (long)edge.cost);
                    parentNodes.put((Comparable)end, start);
                    parentEdges.put((Edge)end, edge);
                    if (i != nodeCount - 1) continue;
                    return end;
                }
            }
        }
        return null;
    }

    public class Edge {
        final V destination;
        final int capacity;
        final int cost;
        int residualFlow;
        int flow;
        Edge counterEdge;
        boolean forwardEdge;
        final /* synthetic */ Graph this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public Edge(V destination, int capacity, int cost, int residualFlow, int flow) {
            this((Graph)this$0, (Comparable)destination, capacity, cost, residualFlow, flow, true);
        }

        /*
         * WARNING - Possible parameter corruption
         */
        public Edge(V destination, int capacity, int cost, int residualFlow, int flow, boolean forwardEdge) {
            this.this$0 = (Graph)this$0;
            Objects.requireNonNull(destination);
            if (capacity < 0) {
                throw new IllegalArgumentException("Edge capacity cannot be negative");
            }
            if (flow > capacity) {
                throw new IllegalArgumentException(String.format("Edge flow %d cannot exceed capacity %d", flow, capacity));
            }
            this.destination = destination;
            this.capacity = capacity;
            this.cost = cost;
            this.residualFlow = residualFlow;
            this.flow = flow;
            this.forwardEdge = forwardEdge;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            Edge otherEdge = (Edge)other;
            return this.destination.equals(otherEdge.destination) && this.capacity == otherEdge.capacity && this.cost == otherEdge.cost && this.residualFlow == otherEdge.residualFlow && this.flow == otherEdge.flow && this.forwardEdge == otherEdge.forwardEdge;
        }

        public int hashCode() {
            return Objects.hash(this.destination, this.capacity, this.cost, this.residualFlow, this.flow, this.forwardEdge);
        }

        public String toString() {
            return "Edge {destination= " + this.destination + ", capacity=" + this.capacity + ", cost=" + this.cost + ", residualFlow=" + this.residualFlow + ", flow=" + this.flow + ", forwardEdge=" + this.forwardEdge + "}";
        }
    }
}

