/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao.repo;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.List;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.AnyMatchDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.DelegationDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.Role;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.api.search.SearchCondConverter;
import org.apache.syncope.core.persistence.api.search.SearchCondVisitor;
import org.apache.syncope.core.persistence.jpa.dao.repo.RoleRepoExt;
import org.apache.syncope.core.persistence.jpa.entity.JPARole;
import org.apache.syncope.core.persistence.jpa.entity.user.JPAUser;
import org.apache.syncope.core.provisioning.api.event.EntityLifecycleEvent;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.transaction.annotation.Transactional;

public class RoleRepoExtImpl
implements RoleRepoExt {
    protected final ApplicationEventPublisher publisher;
    protected final AnyMatchDAO anyMatchDAO;
    protected final AnySearchDAO anySearchDAO;
    protected final DelegationDAO delegationDAO;
    protected final SearchCondVisitor searchCondVisitor;
    protected final EntityManager entityManager;

    public RoleRepoExtImpl(ApplicationEventPublisher publisher, AnyMatchDAO anyMatchDAO, AnySearchDAO anySearchDAO, DelegationDAO delegationDAO, SearchCondVisitor searchCondVisitor, EntityManager entityManager) {
        this.publisher = publisher;
        this.anyMatchDAO = anyMatchDAO;
        this.anySearchDAO = anySearchDAO;
        this.delegationDAO = delegationDAO;
        this.searchCondVisitor = searchCondVisitor;
        this.entityManager = entityManager;
    }

    @Override
    public Role save(Role role) {
        ((JPARole)role).list2json();
        return (Role)this.entityManager.merge((Object)role);
    }

    @Override
    public Role saveAndRefreshDynMemberships(Role role) {
        Role merged = this.save(role);
        this.clearDynMembers(merged);
        if (merged.getDynMembershipCond() != null) {
            List matching = this.anySearchDAO.search(SearchCondConverter.convert((SearchCondVisitor)this.searchCondVisitor, (String)merged.getDynMembershipCond(), (String[])new String[0]), AnyTypeKind.USER);
            matching.forEach(user -> {
                Query insert = this.entityManager.createNativeQuery("INSERT INTO DynRoleMembers VALUES(?, ?)");
                insert.setParameter(1, (Object)user.getKey());
                insert.setParameter(2, (Object)merged.getKey());
                insert.executeUpdate();
                this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Entity)user, AuthContextUtils.getDomain()));
            });
        }
        return merged;
    }

    @Override
    public void delete(Role role) {
        TypedQuery query = this.entityManager.createQuery("SELECT e FROM " + JPAUser.class.getSimpleName() + " e WHERE :role MEMBER OF e.roles", User.class);
        query.setParameter("role", (Object)role);
        query.getResultList().forEach(user -> {
            user.getRoles().remove(role);
            this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Entity)user, AuthContextUtils.getDomain()));
        });
        this.clearDynMembers(role);
        this.delegationDAO.findByRoles(role).forEach(delegation -> delegation.getRoles().remove(role));
        this.entityManager.remove((Object)role);
    }

    @Override
    public List<String> findDynMembers(Role role) {
        if (role.getDynMembershipCond() == null) {
            return List.of();
        }
        Query query = this.entityManager.createNativeQuery("SELECT any_id FROM DynRoleMembers WHERE role_id=?");
        query.setParameter(1, (Object)role.getKey());
        List result = query.getResultList();
        return result.stream().map(Object::toString).toList();
    }

    @Override
    public void clearDynMembers(Role role) {
        Query delete = this.entityManager.createNativeQuery("DELETE FROM DynRoleMembers WHERE role_id=?");
        delete.setParameter(1, (Object)role.getKey());
        delete.executeUpdate();
    }

    @Override
    @Transactional
    public void refreshDynMemberships(User user) {
        this.entityManager.createQuery("SELECT e FROM " + JPARole.class.getSimpleName() + " e WHERE e.dynMembershipCond IS NOT NULL", Role.class).getResultStream().forEach(role -> {
            boolean existing;
            boolean matches = this.anyMatchDAO.matches((Any)user, SearchCondConverter.convert((SearchCondVisitor)this.searchCondVisitor, (String)role.getDynMembershipCond(), (String[])new String[0]));
            Query query = this.entityManager.createNativeQuery("SELECT COUNT(role_id) FROM DynRoleMembers WHERE any_id=? AND role_id=?");
            query.setParameter(1, (Object)user.getKey());
            query.setParameter(2, (Object)role.getKey());
            boolean bl = existing = ((Number)query.getSingleResult()).longValue() > 0L;
            if (matches && !existing) {
                Query insert = this.entityManager.createNativeQuery("INSERT INTO DynRoleMembers VALUES(?, ?)");
                insert.setParameter(1, (Object)user.getKey());
                insert.setParameter(2, (Object)role.getKey());
                insert.executeUpdate();
            } else if (!matches && existing) {
                Query delete = this.entityManager.createNativeQuery("DELETE FROM DynRoleMembers WHERE role_id=? AND any_id=?");
                delete.setParameter(1, (Object)role.getKey());
                delete.setParameter(2, (Object)user.getKey());
                delete.executeUpdate();
            }
        });
    }

    @Override
    public void removeDynMemberships(String key) {
        Query delete = this.entityManager.createNativeQuery("DELETE FROM DynRoleMembers WHERE any_id=?");
        delete.setParameter(1, (Object)key);
        delete.executeUpdate();
    }
}

