/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.rest;

import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.rest.BaseRestClient;
import org.apache.syncope.client.console.rest.ExecutionRestClient;
import org.apache.syncope.client.lib.batch.BatchRequest;
import org.apache.syncope.client.ui.commons.DateOps;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ExecTO;
import org.apache.syncope.common.lib.to.JobTO;
import org.apache.syncope.common.lib.to.ReportTO;
import org.apache.syncope.common.lib.types.JobAction;
import org.apache.syncope.common.rest.api.batch.BatchRequestItem;
import org.apache.syncope.common.rest.api.batch.BatchResponseItem;
import org.apache.syncope.common.rest.api.beans.ExecQuery;
import org.apache.syncope.common.rest.api.beans.ExecSpecs;
import org.apache.syncope.common.rest.api.service.ReportService;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;

public class ReportRestClient
extends BaseRestClient
implements ExecutionRestClient {
    private static final long serialVersionUID = 1644689667998953604L;

    public ReportTO read(String reportKey) {
        return this.getService(ReportService.class).read(reportKey);
    }

    public List<ReportTO> list() {
        return this.getService(ReportService.class).list();
    }

    public JobTO getJob(String key) {
        return this.getService(ReportService.class).getJob(key);
    }

    public List<JobTO> listJobs() {
        return this.getService(ReportService.class).listJobs();
    }

    public void actionJob(String refKey, JobAction jobAction) {
        this.getService(ReportService.class).actionJob(refKey, jobAction);
    }

    public void create(ReportTO reportTO) {
        this.getService(ReportService.class).create(reportTO);
    }

    public void update(ReportTO reportTO) {
        this.getService(ReportService.class).update(reportTO);
    }

    public void delete(String reportKey) {
        this.getService(ReportService.class).delete(reportKey);
    }

    @Override
    public void startExecution(String reportKey, Date startAt) {
        this.getService(ReportService.class).execute(new ExecSpecs.Builder().key(reportKey).startAt(DateOps.toOffsetDateTime((Date)startAt)).build());
    }

    @Override
    public void deleteExecution(String reportExecKey) {
        this.getService(ReportService.class).deleteExecution(reportExecKey);
    }

    @Override
    public List<ExecTO> listRecentExecutions(int max) {
        return this.getService(ReportService.class).listRecentExecutions(max);
    }

    public Optional<Response> exportExecutionResult(String executionKey) {
        try {
            return Optional.of(this.getService(ReportService.class).exportExecutionResult(executionKey));
        }
        catch (SyncopeClientException e) {
            LOG.error("While exporting execution {}", (Object)executionKey, (Object)e);
            return Optional.empty();
        }
    }

    @Override
    public List<ExecTO> listExecutions(String taskKey, int page, int size, SortParam<String> sort) {
        return this.getService(ReportService.class).listExecutions((ExecQuery)((ExecQuery.Builder)((ExecQuery.Builder)((ExecQuery.Builder)new ExecQuery.Builder().key(taskKey).page(Integer.valueOf(page))).size(Integer.valueOf(size))).orderBy(ReportRestClient.toOrderBy(sort))).build()).getResult();
    }

    @Override
    public long countExecutions(String taskKey) {
        return this.getService(ReportService.class).listExecutions((ExecQuery)((ExecQuery.Builder)((ExecQuery.Builder)new ExecQuery.Builder().key(taskKey).page(Integer.valueOf(1))).size(Integer.valueOf(0))).build()).getTotalCount();
    }

    @Override
    public Map<String, String> batch(BatchRequest batchRequest) {
        ArrayList batchRequestItems = new ArrayList(batchRequest.getItems());
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        try {
            List batchResponseItems = batchRequest.commit().getItems();
            for (int i = 0; i < batchResponseItems.size(); ++i) {
                String status = this.getStatus(((BatchResponseItem)batchResponseItems.get(i)).getStatus());
                if (((BatchRequestItem)batchRequestItems.get(i)).getRequestURI().contains("/execute")) {
                    result.put(StringUtils.substringAfterLast((String)StringUtils.substringBefore((String)((BatchRequestItem)batchRequestItems.get(i)).getRequestURI(), (String)"/execute"), (String)"/"), status);
                    continue;
                }
                result.put(StringUtils.substringAfterLast((String)((BatchRequestItem)batchRequestItems.get(i)).getRequestURI(), (String)"/"), status);
            }
        }
        catch (IOException e) {
            LOG.error("While processing Batch response", (Throwable)e);
        }
        return result;
    }
}

