/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.cmd;

import java.io.Serializable;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.api.Job;
import org.flowable.job.service.InternalJobManager;
import org.flowable.job.service.JobServiceConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnlockExclusiveJobCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(UnlockExclusiveJobCmd.class);
    protected Job job;
    protected JobServiceConfiguration jobServiceConfiguration;

    public UnlockExclusiveJobCmd(Job job, JobServiceConfiguration jobServiceConfiguration) {
        this.job = job;
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public Object execute(CommandContext commandContext) {
        InternalJobManager jobScopeInterface;
        if (this.job == null) {
            throw new FlowableIllegalArgumentException("job is null");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Unlocking exclusive job {}", (Object)this.job.getId());
        }
        if (this.job.isExclusive() && (this.job.getProcessInstanceId() != null || this.job.getScopeId() != null) && (jobScopeInterface = this.jobServiceConfiguration.getInternalJobManager()) != null) {
            jobScopeInterface.clearJobScopeLock(this.job);
        }
        return null;
    }
}

