/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.assertj;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.function.Predicate;
import org.assertj.core.api.AbstractMapAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.internal.Failures;
import org.springframework.lang.Nullable;
import org.springframework.test.validation.AbstractBindingResultAssert;
import org.springframework.validation.BindingResult;
import org.springframework.validation.BindingResultUtils;
import org.springframework.validation.Errors;

public class ModelAssert
extends AbstractMapAssert<ModelAssert, Map<String, Object>, String, Object> {
    private final Failures failures = Failures.instance();

    public ModelAssert(Map<String, Object> map) {
        super(map, ModelAssert.class);
    }

    public AbstractBindingResultAssert<?> extractingBindingResult(String name) {
        BindingResult result = BindingResultUtils.getBindingResult((Map)((Map)this.actual), (String)name);
        if (result == null) {
            throw this.unexpectedModel("to have a binding result for attribute '%s'", name);
        }
        return new BindingResultAssert(name, result);
    }

    public ModelAssert hasErrors() {
        if (this.getAllErrors() == 0) {
            throw this.unexpectedModel("to have at least one error", new Object[0]);
        }
        return (ModelAssert)this.myself;
    }

    public ModelAssert doesNotHaveErrors() {
        int count = this.getAllErrors();
        if (count > 0) {
            throw this.unexpectedModel("to not have an error, but got %s", count);
        }
        return (ModelAssert)this.myself;
    }

    public ModelAssert hasAttributeErrors(String ... names) {
        return this.assertAttributes(names, Errors::hasErrors, "to have attribute errors for", "these attributes do not have any errors");
    }

    public ModelAssert doesNotHaveAttributeErrors(String ... names) {
        return this.assertAttributes(names, Predicate.not(Errors::hasErrors), "to have attribute without errors for", "these attributes have at least one error");
    }

    private ModelAssert assertAttributes(String[] names, Predicate<BindingResult> condition, String assertionMessage, String failAssertionMessage) {
        LinkedHashSet<String> missing = new LinkedHashSet<String>();
        LinkedHashSet<String> failCondition = new LinkedHashSet<String>();
        for (String name : names) {
            BindingResult bindingResult = this.getBindingResult(name);
            if (bindingResult == null) {
                missing.add(name);
                continue;
            }
            if (condition.test(bindingResult)) continue;
            failCondition.add(name);
        }
        if (!missing.isEmpty() || !failCondition.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("%n%s:%n  %s%n".formatted(assertionMessage, String.join((CharSequence)", ", names)));
            if (!missing.isEmpty()) {
                sb.append("%nbut could not find these attributes:%n  %s%n".formatted(String.join((CharSequence)", ", missing)));
            }
            if (!failCondition.isEmpty()) {
                String prefix = missing.isEmpty() ? "but" : "and";
                sb.append("%n%s %s:%n  %s%n".formatted(prefix, failAssertionMessage, String.join((CharSequence)", ", failCondition)));
            }
            throw this.unexpectedModel(sb.toString(), new Object[0]);
        }
        return (ModelAssert)this.myself;
    }

    private AssertionError unexpectedModel(String reason, Object ... arguments) {
        return this.failures.failure((AssertionInfo)this.info, (ErrorMessageFactory)new UnexpectedModel(reason, arguments));
    }

    private int getAllErrors() {
        return ((Map)this.actual).values().stream().filter(Errors.class::isInstance).map(Errors.class::cast).map(Errors::getErrorCount).reduce(0, Integer::sum);
    }

    @Nullable
    private BindingResult getBindingResult(String name) {
        return BindingResultUtils.getBindingResult((Map)((Map)this.actual), (String)name);
    }

    private static final class BindingResultAssert
    extends AbstractBindingResultAssert<BindingResultAssert> {
        public BindingResultAssert(String name, BindingResult bindingResult) {
            super(name, bindingResult, BindingResultAssert.class);
        }
    }

    private final class UnexpectedModel
    extends BasicErrorMessageFactory {
        private UnexpectedModel(String reason, Object ... arguments) {
            super("%nExpecting model:%n  %s%n%s", new Object[]{ModelAssert.this.actual, reason.formatted(arguments)});
        }
    }
}

