/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import org.apache.kafka.clients.consumer.internals.CommitRequestManager;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.CoordinatorRequestManager;
import org.apache.kafka.clients.consumer.internals.FetchRequestManager;
import org.apache.kafka.clients.consumer.internals.HeartbeatRequestManager;
import org.apache.kafka.clients.consumer.internals.MembershipManager;
import org.apache.kafka.clients.consumer.internals.NetworkClientDelegate;
import org.apache.kafka.clients.consumer.internals.OffsetsRequestManager;
import org.apache.kafka.clients.consumer.internals.RequestManagers;
import org.apache.kafka.clients.consumer.internals.TopicMetadataRequestManager;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEventProcessor;
import org.apache.kafka.clients.consumer.internals.events.CommitOnCloseEvent;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class ApplicationEventProcessorTest {
    private final Time time = new MockTime(1L);
    private final BlockingQueue applicationEventQueue = (BlockingQueue)Mockito.mock(BlockingQueue.class);
    private final ConsumerMetadata metadata = (ConsumerMetadata)Mockito.mock(ConsumerMetadata.class);
    private ApplicationEventProcessor processor;
    private CommitRequestManager commitRequestManager;
    private HeartbeatRequestManager heartbeatRequestManager;
    private MembershipManager membershipManager;

    @BeforeEach
    public void setup() {
        LogContext logContext = new LogContext();
        OffsetsRequestManager offsetsRequestManager = (OffsetsRequestManager)Mockito.mock(OffsetsRequestManager.class);
        TopicMetadataRequestManager topicMetadataRequestManager = (TopicMetadataRequestManager)Mockito.mock(TopicMetadataRequestManager.class);
        FetchRequestManager fetchRequestManager = (FetchRequestManager)Mockito.mock(FetchRequestManager.class);
        CoordinatorRequestManager coordinatorRequestManager = (CoordinatorRequestManager)Mockito.mock(CoordinatorRequestManager.class);
        this.commitRequestManager = (CommitRequestManager)Mockito.mock(CommitRequestManager.class);
        this.heartbeatRequestManager = (HeartbeatRequestManager)Mockito.mock(HeartbeatRequestManager.class);
        this.membershipManager = (MembershipManager)Mockito.mock(MembershipManager.class);
        RequestManagers requestManagers = new RequestManagers(logContext, offsetsRequestManager, topicMetadataRequestManager, fetchRequestManager, Optional.of(coordinatorRequestManager), Optional.of(this.commitRequestManager), Optional.of(this.heartbeatRequestManager), Optional.of(this.membershipManager));
        this.processor = new ApplicationEventProcessor(new LogContext(), requestManagers, this.metadata);
    }

    @Test
    public void testPrepClosingCommitEvents() {
        List<NetworkClientDelegate.UnsentRequest> results = this.mockCommitResults();
        ((CommitRequestManager)Mockito.doReturn((Object)new NetworkClientDelegate.PollResult(100L, results)).when((Object)this.commitRequestManager)).pollOnClose();
        this.processor.process((ApplicationEvent)new CommitOnCloseEvent());
        ((CommitRequestManager)Mockito.verify((Object)this.commitRequestManager)).signalClose();
    }

    private List<NetworkClientDelegate.UnsentRequest> mockCommitResults() {
        return Collections.singletonList(Mockito.mock(NetworkClientDelegate.UnsentRequest.class));
    }
}

