/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.telemetry.internals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.apache.kafka.common.telemetry.internals.MetricKeyable;
import org.apache.kafka.common.telemetry.internals.MetricsEmitter;
import org.apache.kafka.common.telemetry.internals.SinglePointMetric;

public class TestEmitter
implements MetricsEmitter {
    private final List<SinglePointMetric> emittedMetrics;
    private Predicate<? super MetricKeyable> metricsPredicate = metricKeyable -> true;
    private boolean onlyDeltaMetrics;

    public TestEmitter() {
        this(false);
    }

    public TestEmitter(boolean onlyDeltaMetrics) {
        this.emittedMetrics = new ArrayList<SinglePointMetric>();
        this.onlyDeltaMetrics = onlyDeltaMetrics;
    }

    public boolean shouldEmitMetric(MetricKeyable metricKeyable) {
        return this.metricsPredicate.test((MetricKeyable)metricKeyable);
    }

    public boolean shouldEmitDeltaMetrics() {
        return this.onlyDeltaMetrics;
    }

    public boolean emitMetric(SinglePointMetric metric) {
        return this.emittedMetrics.add(metric);
    }

    public List<SinglePointMetric> emittedMetrics() {
        return Collections.unmodifiableList(this.emittedMetrics);
    }

    public void reset() {
        this.emittedMetrics.clear();
    }

    public void onlyDeltaMetrics(boolean onlyDeltaMetrics) {
        this.onlyDeltaMetrics = onlyDeltaMetrics;
    }

    public void reconfigurePredicate(Predicate<? super MetricKeyable> metricsPredicate) {
        this.metricsPredicate = metricsPredicate;
    }
}

