/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.model.builder.xml;

import java.io.IOException;
import org.springframework.core.io.ClassPathResource;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

class WebFlowEntityResolver
implements EntityResolver {
    private static final String SPRING_WEBFLOW_XSD = "spring-webflow.xsd";
    private static final String[] WEBFLOW_VERSIONS = new String[]{"spring-webflow-2.4", "spring-webflow-2.0"};

    WebFlowEntityResolver() {
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        if (systemId != null && systemId.contains(SPRING_WEBFLOW_XSD)) {
            return this.createInputSource(publicId, systemId, SPRING_WEBFLOW_XSD);
        }
        for (String element : WEBFLOW_VERSIONS) {
            if (systemId == null || systemId.indexOf(element) <= systemId.lastIndexOf("/")) continue;
            return this.createInputSource(publicId, systemId, SPRING_WEBFLOW_XSD);
        }
        return null;
    }

    private InputSource createInputSource(String publicId, String systemId, String fileName) {
        try {
            ClassPathResource resource = new ClassPathResource(fileName, this.getClass());
            InputSource source = new InputSource(resource.getInputStream());
            source.setPublicId(publicId);
            source.setSystemId(systemId);
            return source;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

