/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.client.validation;

import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apereo.cas.client.Protocol;
import org.apereo.cas.client.configuration.ConfigurationKeys;
import org.apereo.cas.client.proxy.AbstractEncryptedProxyGrantingTicketStorageImpl;
import org.apereo.cas.client.proxy.Cas20ProxyRetriever;
import org.apereo.cas.client.proxy.CleanUpTimerTask;
import org.apereo.cas.client.proxy.ProxyGrantingTicketStorage;
import org.apereo.cas.client.proxy.ProxyGrantingTicketStorageImpl;
import org.apereo.cas.client.ssl.HttpsURLConnectionFactory;
import org.apereo.cas.client.util.CommonUtils;
import org.apereo.cas.client.util.PrivateKeyUtils;
import org.apereo.cas.client.util.ReflectUtils;
import org.apereo.cas.client.util.WebUtils;
import org.apereo.cas.client.validation.AbstractTicketValidationFilter;
import org.apereo.cas.client.validation.Cas20ProxyTicketValidator;
import org.apereo.cas.client.validation.Cas20ServiceTicketValidator;
import org.apereo.cas.client.validation.TicketValidator;

public class Cas20ProxyReceivingTicketValidationFilter
extends AbstractTicketValidationFilter {
    private static final String[] RESERVED_INIT_PARAMS = new String[]{ConfigurationKeys.ARTIFACT_PARAMETER_NAME.getName(), ConfigurationKeys.SERVER_NAME.getName(), ConfigurationKeys.SERVICE.getName(), ConfigurationKeys.RENEW.getName(), ConfigurationKeys.LOGOUT_PARAMETER_NAME.getName(), ConfigurationKeys.ARTIFACT_PARAMETER_OVER_POST.getName(), ConfigurationKeys.EAGERLY_CREATE_SESSIONS.getName(), ConfigurationKeys.ENCODE_SERVICE_URL.getName(), ConfigurationKeys.SSL_CONFIG_FILE.getName(), ConfigurationKeys.ROLE_ATTRIBUTE.getName(), ConfigurationKeys.IGNORE_CASE.getName(), ConfigurationKeys.CAS_SERVER_LOGIN_URL.getName(), ConfigurationKeys.GATEWAY.getName(), ConfigurationKeys.AUTHENTICATION_REDIRECT_STRATEGY_CLASS.getName(), ConfigurationKeys.GATEWAY_STORAGE_CLASS.getName(), ConfigurationKeys.CAS_SERVER_URL_PREFIX.getName(), ConfigurationKeys.ENCODING.getName(), ConfigurationKeys.TOLERANCE.getName(), ConfigurationKeys.IGNORE_PATTERN.getName(), ConfigurationKeys.IGNORE_URL_PATTERN_TYPE.getName(), ConfigurationKeys.HOSTNAME_VERIFIER.getName(), ConfigurationKeys.HOSTNAME_VERIFIER_CONFIG.getName(), ConfigurationKeys.EXCEPTION_ON_VALIDATION_FAILURE.getName(), ConfigurationKeys.REDIRECT_AFTER_VALIDATION.getName(), ConfigurationKeys.USE_SESSION.getName(), ConfigurationKeys.SECRET_KEY.getName(), ConfigurationKeys.CIPHER_ALGORITHM.getName(), ConfigurationKeys.PROXY_RECEPTOR_URL.getName(), ConfigurationKeys.PROXY_GRANTING_TICKET_STORAGE_CLASS.getName(), ConfigurationKeys.MILLIS_BETWEEN_CLEAN_UPS.getName(), ConfigurationKeys.ACCEPT_ANY_PROXY.getName(), ConfigurationKeys.ALLOWED_PROXY_CHAINS.getName(), ConfigurationKeys.TICKET_VALIDATOR_CLASS.getName(), ConfigurationKeys.PROXY_CALLBACK_URL.getName(), ConfigurationKeys.RELAY_STATE_PARAMETER_NAME.getName(), ConfigurationKeys.METHOD.getName(), ConfigurationKeys.PRIVATE_KEY_PATH.getName(), ConfigurationKeys.PRIVATE_KEY_ALGORITHM.getName()};
    protected Class<? extends Cas20ServiceTicketValidator> defaultServiceTicketValidatorClass;
    protected Class<? extends Cas20ProxyTicketValidator> defaultProxyTicketValidatorClass;
    private String proxyReceptorUrl;
    private Timer timer;
    private TimerTask timerTask;
    private int millisBetweenCleanUps;
    private PrivateKey privateKey;
    private ProxyGrantingTicketStorage proxyGrantingTicketStorage = new ProxyGrantingTicketStorageImpl();

    public Cas20ProxyReceivingTicketValidationFilter() {
        this(Protocol.CAS2);
        this.defaultServiceTicketValidatorClass = Cas20ServiceTicketValidator.class;
        this.defaultProxyTicketValidatorClass = Cas20ProxyTicketValidator.class;
    }

    protected Cas20ProxyReceivingTicketValidationFilter(Protocol protocol) {
        super(protocol);
    }

    public static PrivateKey buildPrivateKey(String keyPath, String keyAlgorithm) {
        if (keyPath != null) {
            return PrivateKeyUtils.createKey(keyPath, keyAlgorithm);
        }
        return null;
    }

    @Override
    public void init() {
        super.init();
        CommonUtils.assertNotNull(this.proxyGrantingTicketStorage, "proxyGrantingTicketStorage cannot be null.");
        if (this.timer == null) {
            this.timer = new Timer(true);
        }
        if (this.timerTask == null) {
            this.timerTask = new CleanUpTimerTask(this.proxyGrantingTicketStorage);
        }
        this.timer.schedule(this.timerTask, this.millisBetweenCleanUps, (long)this.millisBetweenCleanUps);
    }

    @Override
    protected void initInternal(FilterConfig filterConfig) throws ServletException {
        this.setProxyReceptorUrl(this.getString(ConfigurationKeys.PROXY_RECEPTOR_URL));
        Class proxyGrantingTicketStorageClass = this.getClass(ConfigurationKeys.PROXY_GRANTING_TICKET_STORAGE_CLASS);
        if (proxyGrantingTicketStorageClass != null) {
            this.proxyGrantingTicketStorage = (ProxyGrantingTicketStorage)ReflectUtils.newInstance(proxyGrantingTicketStorageClass, new Object[0]);
            if (this.proxyGrantingTicketStorage instanceof AbstractEncryptedProxyGrantingTicketStorageImpl) {
                AbstractEncryptedProxyGrantingTicketStorageImpl p = (AbstractEncryptedProxyGrantingTicketStorageImpl)this.proxyGrantingTicketStorage;
                String cipherAlgorithm = this.getString(ConfigurationKeys.CIPHER_ALGORITHM);
                String secretKey = this.getString(ConfigurationKeys.SECRET_KEY);
                p.setCipherAlgorithm(cipherAlgorithm);
                try {
                    if (secretKey != null) {
                        p.setSecretKey(secretKey);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.millisBetweenCleanUps = this.getInt(ConfigurationKeys.MILLIS_BETWEEN_CLEAN_UPS);
        this.privateKey = Cas20ProxyReceivingTicketValidationFilter.buildPrivateKey(this.getString(ConfigurationKeys.PRIVATE_KEY_PATH), this.getString(ConfigurationKeys.PRIVATE_KEY_ALGORITHM));
        super.initInternal(filterConfig);
    }

    @Override
    protected final TicketValidator getTicketValidator(FilterConfig filterConfig) {
        Cas20ServiceTicketValidator validator;
        boolean allowAnyProxy = this.getBoolean(ConfigurationKeys.ACCEPT_ANY_PROXY);
        String allowedProxyChains = this.getString(ConfigurationKeys.ALLOWED_PROXY_CHAINS);
        String casServerUrlPrefix = this.getString(ConfigurationKeys.CAS_SERVER_URL_PREFIX);
        Class ticketValidatorClass = this.getClass(ConfigurationKeys.TICKET_VALIDATOR_CLASS);
        if (allowAnyProxy || CommonUtils.isNotBlank(allowedProxyChains)) {
            Cas20ProxyTicketValidator v = Cas20ProxyReceivingTicketValidationFilter.createNewTicketValidator(ticketValidatorClass, casServerUrlPrefix, this.defaultProxyTicketValidatorClass);
            v.setAcceptAnyProxy(allowAnyProxy);
            v.setAllowedProxyChains(CommonUtils.createProxyList(allowedProxyChains));
            validator = v;
        } else {
            validator = Cas20ProxyReceivingTicketValidationFilter.createNewTicketValidator(ticketValidatorClass, casServerUrlPrefix, this.defaultServiceTicketValidatorClass);
        }
        validator.setProxyCallbackUrl(this.getString(ConfigurationKeys.PROXY_CALLBACK_URL));
        validator.setProxyGrantingTicketStorage(this.proxyGrantingTicketStorage);
        HttpsURLConnectionFactory factory = new HttpsURLConnectionFactory(this.getHostnameVerifier(), this.getSSLConfig());
        validator.setURLConnectionFactory(factory);
        validator.setProxyRetriever(new Cas20ProxyRetriever(casServerUrlPrefix, this.getString(ConfigurationKeys.ENCODING), factory));
        validator.setRenew(this.getBoolean(ConfigurationKeys.RENEW));
        validator.setEncoding(this.getString(ConfigurationKeys.ENCODING));
        HashMap<String, String> additionalParameters = new HashMap<String, String>();
        List<String> params = Arrays.asList(RESERVED_INIT_PARAMS);
        Enumeration e = filterConfig.getInitParameterNames();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (params.contains(s)) continue;
            additionalParameters.put(s, filterConfig.getInitParameter(s));
        }
        validator.setPrivateKey(this.privateKey);
        validator.setCustomParameters(additionalParameters);
        return validator;
    }

    @Override
    protected final boolean preFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String requestUri = request.getRequestURI();
        if (CommonUtils.isEmpty(this.proxyReceptorUrl) || !requestUri.endsWith(this.proxyReceptorUrl)) {
            return true;
        }
        try {
            WebUtils.readAndRespondToProxyReceptorRequest((ServletRequest)request, (ServletResponse)response, this.proxyGrantingTicketStorage);
        }
        catch (RuntimeException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        return false;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.timer.cancel();
    }

    public final void setProxyReceptorUrl(String proxyReceptorUrl) {
        this.proxyReceptorUrl = proxyReceptorUrl;
    }

    public void setProxyGrantingTicketStorage(ProxyGrantingTicketStorage storage) {
        this.proxyGrantingTicketStorage = storage;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public void setTimerTask(TimerTask timerTask) {
        this.timerTask = timerTask;
    }

    public void setMillisBetweenCleanUps(int millisBetweenCleanUps) {
        this.millisBetweenCleanUps = millisBetweenCleanUps;
    }

    private static <T> T createNewTicketValidator(Class<? extends Cas20ServiceTicketValidator> ticketValidatorClass, String casServerUrlPrefix, Class<T> clazz) {
        if (ticketValidatorClass == null) {
            return ReflectUtils.newInstance(clazz, casServerUrlPrefix);
        }
        return (T)ReflectUtils.newInstance(ticketValidatorClass, casServerUrlPrefix);
    }
}

