/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.convert.converter;

import java.text.Format;
import java.text.ParsePosition;
import java.util.Locale;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;

public abstract class AbstractConverter<C>
implements IConverter<C> {
    private static final long serialVersionUID = 1L;

    protected C parse(Format format, Object value, Locale locale) {
        ParsePosition position = new ParsePosition(0);
        String stringValue = value.toString();
        Object result = format.parseObject(stringValue, position);
        if (position.getIndex() != stringValue.length()) {
            throw this.newConversionException("Cannot parse '" + String.valueOf(value) + "' using format " + String.valueOf(format), value, locale).setFormat(format);
        }
        return (C)result;
    }

    protected ConversionException newConversionException(String message, Object value, Locale locale) {
        return new ConversionException(message).setSourceValue(value).setTargetType(this.getTargetType()).setConverter(this).setLocale(locale);
    }

    protected abstract Class<C> getTargetType();

    @Override
    public String convertToString(C value, Locale locale) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }
}

