/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;

public final class XxHash64 {
    private static final long P1 = -7046029288634856825L;
    private static final long P2 = -4417276706812531889L;
    private static final long P3 = 1609587929392839161L;
    private static final long P4 = -8796714831421723037L;
    private static final long P5 = 2870177450012600261L;

    static long hash(MemorySegment seg, long offsetBytes, long lengthBytes, long seed) {
        long hash;
        long remaining = lengthBytes;
        if (remaining >= 32L) {
            long v1 = seed + -7046029288634856825L + -4417276706812531889L;
            long v2 = seed + -4417276706812531889L;
            long v3 = seed;
            long v4 = seed - -7046029288634856825L;
            do {
                v1 += seg.get(ValueLayout.JAVA_LONG_UNALIGNED, offsetBytes) * -4417276706812531889L;
                v1 = Long.rotateLeft(v1, 31);
                v1 *= -7046029288634856825L;
                v2 += seg.get(ValueLayout.JAVA_LONG_UNALIGNED, offsetBytes + 8L) * -4417276706812531889L;
                v2 = Long.rotateLeft(v2, 31);
                v2 *= -7046029288634856825L;
                v3 += seg.get(ValueLayout.JAVA_LONG_UNALIGNED, offsetBytes + 16L) * -4417276706812531889L;
                v3 = Long.rotateLeft(v3, 31);
                v3 *= -7046029288634856825L;
                v4 += seg.get(ValueLayout.JAVA_LONG_UNALIGNED, offsetBytes + 24L) * -4417276706812531889L;
                v4 = Long.rotateLeft(v4, 31);
                v4 *= -7046029288634856825L;
                offsetBytes += 32L;
            } while ((remaining -= 32L) >= 32L);
            hash = Long.rotateLeft(v1, 1) + Long.rotateLeft(v2, 7) + Long.rotateLeft(v3, 12) + Long.rotateLeft(v4, 18);
            v1 *= -4417276706812531889L;
            v1 = Long.rotateLeft(v1, 31);
            hash ^= (v1 *= -7046029288634856825L);
            hash = hash * -7046029288634856825L + -8796714831421723037L;
            v2 *= -4417276706812531889L;
            v2 = Long.rotateLeft(v2, 31);
            hash ^= (v2 *= -7046029288634856825L);
            hash = hash * -7046029288634856825L + -8796714831421723037L;
            v3 *= -4417276706812531889L;
            v3 = Long.rotateLeft(v3, 31);
            hash ^= (v3 *= -7046029288634856825L);
            hash = hash * -7046029288634856825L + -8796714831421723037L;
            v4 *= -4417276706812531889L;
            v4 = Long.rotateLeft(v4, 31);
            hash ^= (v4 *= -7046029288634856825L);
            hash = hash * -7046029288634856825L + -8796714831421723037L;
        } else {
            hash = seed + 2870177450012600261L;
        }
        hash += lengthBytes;
        while (remaining >= 8L) {
            long k1 = seg.get(ValueLayout.JAVA_LONG_UNALIGNED, offsetBytes);
            k1 *= -4417276706812531889L;
            k1 = Long.rotateLeft(k1, 31);
            hash ^= (k1 *= -7046029288634856825L);
            hash = Long.rotateLeft(hash, 27) * -7046029288634856825L + -8796714831421723037L;
            offsetBytes += 8L;
            remaining -= 8L;
        }
        if (remaining >= 4L) {
            hash ^= ((long)seg.get(ValueLayout.JAVA_INT_UNALIGNED, offsetBytes) & 0xFFFFFFFFL) * -7046029288634856825L;
            hash = Long.rotateLeft(hash, 23) * -4417276706812531889L + 1609587929392839161L;
            offsetBytes += 4L;
            remaining -= 4L;
        }
        while (remaining != 0L) {
            hash ^= ((long)seg.get(ValueLayout.JAVA_BYTE, offsetBytes) & 0xFFL) * 2870177450012600261L;
            hash = Long.rotateLeft(hash, 11) * -7046029288634856825L;
            --remaining;
            ++offsetBytes;
        }
        return XxHash64.finalize(hash);
    }

    public static long hash(long in, long seed) {
        long hash = seed + 2870177450012600261L;
        hash += 8L;
        long k1 = in;
        k1 *= -4417276706812531889L;
        k1 = Long.rotateLeft(k1, 31);
        hash ^= (k1 *= -7046029288634856825L);
        hash = Long.rotateLeft(hash, 27) * -7046029288634856825L + -8796714831421723037L;
        return XxHash64.finalize(hash);
    }

    private static long finalize(long hash) {
        hash ^= hash >>> 33;
        hash *= -4417276706812531889L;
        hash ^= hash >>> 29;
        hash *= 1609587929392839161L;
        hash ^= hash >>> 32;
        return hash;
    }

    public static long hashBytes(byte[] arr, int offsetBytes, int lengthBytes, long seed) {
        MemorySegment seg = MemorySegment.ofArray(arr);
        return XxHash64.hash(seg, offsetBytes, lengthBytes, seed);
    }

    public static long hashShorts(short[] arr, int offsetShorts, int lengthShorts, long seed) {
        MemorySegment seg = MemorySegment.ofArray(arr);
        return XxHash64.hash(seg, offsetShorts << 1, lengthShorts << 1, seed);
    }

    public static long hashChars(char[] arr, int offsetChars, int lengthChars, long seed) {
        MemorySegment seg = MemorySegment.ofArray(arr);
        return XxHash64.hash(seg, offsetChars << 1, lengthChars << 1, seed);
    }

    public static long hashInts(int[] arr, int offsetInts, int lengthInts, long seed) {
        MemorySegment seg = MemorySegment.ofArray(arr);
        return XxHash64.hash(seg, offsetInts << 2, lengthInts << 2, seed);
    }

    public static long hashLongs(long[] arr, int offsetLongs, int lengthLongs, long seed) {
        MemorySegment seg = MemorySegment.ofArray(arr);
        return XxHash64.hash(seg, offsetLongs << 3, lengthLongs << 3, seed);
    }

    public static long hashFloats(float[] arr, int offsetFloats, int lengthFloats, long seed) {
        MemorySegment seg = MemorySegment.ofArray(arr);
        return XxHash64.hash(seg, offsetFloats << 2, lengthFloats << 2, seed);
    }

    public static long hashDoubles(double[] arr, int offsetDoubles, int lengthDoubles, long seed) {
        MemorySegment seg = MemorySegment.ofArray(arr);
        return XxHash64.hash(seg, offsetDoubles << 3, lengthDoubles << 3, seed);
    }

    public static long hashString(String str, int offsetChars, int lengthChars, long seed) {
        MemorySegment seg = MemorySegment.ofArray(str.toCharArray());
        return XxHash64.hash(seg, offsetChars << 1, lengthChars << 1, seed);
    }

    private XxHash64() {
    }
}

