/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.csn.Csn;
import org.apache.directory.api.ldap.model.csn.InvalidCSNException;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;

public final class CsnSyntaxChecker
extends SyntaxChecker {
    public static final CsnSyntaxChecker INSTANCE = new CsnSyntaxChecker("1.3.6.1.4.1.4203.666.11.2.1");

    private CsnSyntaxChecker(String oid) {
        super(oid);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isValidSyntax(Object value) {
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_04488_SYNTAX_INVALID, "null"));
            }
            return false;
        }
        if (!(value instanceof String)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_04488_SYNTAX_INVALID, value));
            }
            return false;
        }
        String csnStr = (String)value;
        try {
            boolean result = Csn.isValid(csnStr);
            if (LOG.isDebugEnabled()) {
                if (result) {
                    LOG.debug(I18n.msg(I18n.MSG_04489_SYNTAX_VALID, value));
                } else {
                    LOG.debug(I18n.err(I18n.ERR_04488_SYNTAX_INVALID, value));
                }
            }
            return result;
        }
        catch (InvalidCSNException icsne) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_04488_SYNTAX_INVALID, value));
            }
            return false;
        }
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<CsnSyntaxChecker> {
        private Builder() {
            super("1.3.6.1.4.1.4203.666.11.2.1");
        }

        @Override
        public CsnSyntaxChecker build() {
            return new CsnSyntaxChecker(this.oid);
        }
    }
}

