/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AbstractProxyImpl;
import com.ibm.as400.access.JDConnectionProxy;
import com.ibm.as400.access.JDInputStreamProxy;
import com.ibm.as400.access.JDOutputStreamProxy;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.sql.Blob;
import java.sql.SQLException;

class JDBlobProxy
extends AbstractProxyImpl
implements Blob {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    static final String EXC_FUNCTION_NOT_SUPPORTED = "IM001";

    JDBlobProxy() {
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        try {
            JDInputStreamProxy newStream = new JDInputStreamProxy();
            return (JDInputStreamProxy)this.connection_.callFactoryMethod(this.pxId_, "getBinaryStream", newStream);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    @Override
    public byte[] getBytes(long start, int length) throws SQLException {
        try {
            return (byte[])this.connection_.callMethod(this.pxId_, "getBytes", new Class[]{Long.TYPE, Integer.TYPE}, new Object[]{start, length}).getReturnValue();
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    @Override
    public long length() throws SQLException {
        try {
            return this.connection_.callMethod(this.pxId_, "length").getReturnValueLong();
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        try {
            return this.connection_.callMethod(this.pxId_, "position", new Class[]{byte[].class, Long.TYPE}, new Object[]{pattern, start}).getReturnValueLong();
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        try {
            return this.connection_.callMethod(this.pxId_, "position", new Class[]{Blob.class, Long.TYPE}, new Object[]{pattern, start}).getReturnValueLong();
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        try {
            JDOutputStreamProxy newStream = new JDOutputStreamProxy();
            return (JDOutputStreamProxy)this.connection_.callFactoryMethod(this.pxId_, "setBinaryStream", new Class[]{Long.TYPE}, new Object[]{pos}, newStream);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        try {
            return this.connection_.callMethod(this.pxId_, "setBytes", new Class[]{Long.TYPE, byte[].class}, new Object[]{pos, bytes}).getReturnValueInt();
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        try {
            return this.connection_.callMethod(this.pxId_, "setBytes", new Class[]{Long.TYPE, byte[].class, Integer.TYPE, Integer.TYPE}, new Object[]{pos, bytes, offset, len}).getReturnValueInt();
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    @Override
    public void truncate(long len) throws SQLException {
        try {
            this.connection_.callMethod(this.pxId_, "truncate", new Class[]{Long.TYPE}, new Object[]{len});
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    @Override
    public synchronized void free() throws SQLException {
        try {
            this.connection_.callMethod(this.pxId_, "free");
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }

    @Override
    public synchronized InputStream getBinaryStream(long pos, long length) throws SQLException {
        try {
            JDInputStreamProxy newStream = new JDInputStreamProxy();
            return (JDInputStreamProxy)this.connection_.callFactoryMethod(this.pxId_, "getBinaryStream", new Class[]{Long.TYPE, Long.TYPE}, new Object[]{pos, length}, newStream);
        }
        catch (InvocationTargetException e) {
            throw JDConnectionProxy.rethrow1(e);
        }
    }
}

