/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc.tools;

import java.io.IOException;
import java.nio.file.Paths;
import org.netpreserve.jwarc.MediaType;
import org.netpreserve.jwarc.WarcReader;
import org.netpreserve.jwarc.WarcRecord;
import org.netpreserve.jwarc.WarcRequest;
import org.netpreserve.jwarc.WarcResponse;
import org.netpreserve.jwarc.WarcTargetRecord;

public class ListTool {
    public static void main(String[] args) throws IOException {
        for (String arg : args) {
            try (WarcReader reader = new WarcReader(Paths.get(arg, new String[0]));){
                for (WarcRecord record : reader) {
                    String url = "-";
                    if (record instanceof WarcTargetRecord) {
                        url = ((WarcTargetRecord)record).target();
                    }
                    String methodOrStatus = "-";
                    if (record.contentType().base().equals(MediaType.HTTP)) {
                        if (record instanceof WarcRequest) {
                            methodOrStatus = ((WarcRequest)record).http().method();
                        } else if (record instanceof WarcResponse) {
                            methodOrStatus = String.valueOf(((WarcResponse)record).http().status());
                        }
                    }
                    System.out.format("%10d %-10s %-4s %s\n", reader.position(), record.type(), methodOrStatus, url);
                }
            }
        }
    }
}

