/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.perspective.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiRegistry;
import org.apache.hop.core.gui.plugin.key.GuiKeyboardShortcut;
import org.apache.hop.core.gui.plugin.key.GuiOsxKeyboardShortcut;
import org.apache.hop.core.gui.plugin.tab.GuiTabItem;
import org.apache.hop.core.search.ISearchable;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.context.IGuiContextHandler;
import org.apache.hop.ui.hopgui.file.IHopFileType;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;
import org.apache.hop.ui.hopgui.file.empty.EmptyHopFileTypeHandler;
import org.apache.hop.ui.hopgui.perspective.HopPerspectivePlugin;
import org.apache.hop.ui.hopgui.perspective.IHopPerspective;
import org.apache.hop.ui.hopgui.perspective.TabClosable;
import org.apache.hop.ui.hopgui.perspective.TabItemHandler;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

@HopPerspectivePlugin(id="160-HopConfigurationPerspective", name="i18n::ConfigurationPerspective.Name", description="i18n::ConfigurationPerspective.Description", image="ui/images/gear.svg", documentationUrl="/hop-gui/perspective-configuration.html")
@GuiPlugin(description="i18n::HopConfigurationPerspective.GuiPlugin.Description")
public class ConfigurationPerspective
implements IHopPerspective,
TabClosable {
    public static final String CONFIG_PERSPECTIVE_TABS = "ConfigurationPerspective.Tabs.ID";
    private HopGui hopGui;
    private Composite composite;
    public CTabFolder configTabs;
    private static ConfigurationPerspective instance;

    public static ConfigurationPerspective getInstance() {
        return instance;
    }

    public ConfigurationPerspective() {
        instance = this;
    }

    @Override
    public List<IGuiContextHandler> getContextHandlers() {
        return new ArrayList<IGuiContextHandler>();
    }

    @Override
    public String getId() {
        return "configuration";
    }

    @Override
    public IHopFileTypeHandler getActiveFileTypeHandler() {
        return new EmptyHopFileTypeHandler();
    }

    @Override
    public void setActiveFileTypeHandler(IHopFileTypeHandler activeFileTypeHandler) {
    }

    @Override
    public List<IHopFileType> getSupportedHopFileTypes() {
        return Collections.emptyList();
    }

    @Override
    @GuiKeyboardShortcut(control=true, shift=true, key=99)
    @GuiOsxKeyboardShortcut(command=true, shift=true, key=99)
    public void activate() {
        this.hopGui.setActivePerspective(this);
    }

    @Override
    public void perspectiveActivated() {
    }

    @Override
    public void navigateToPreviousFile() {
    }

    @Override
    public void navigateToNextFile() {
    }

    @Override
    public boolean isActive() {
        return this.hopGui.isActivePerspective(this);
    }

    @Override
    public void initialize(HopGui hopGui, Composite parent) {
        this.hopGui = hopGui;
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new FillLayout());
        PropsUi.setLook((Widget)this.composite);
        this.configTabs = new CTabFolder(this.composite, 2048);
        PropsUi.setLook((Widget)this.configTabs, 4);
        this.configTabs.setMaximized(true);
        GuiRegistry guiRegistry = GuiRegistry.getInstance();
        List tabsList = (List)guiRegistry.getGuiTabsMap().get(CONFIG_PERSPECTIVE_TABS);
        if (tabsList != null) {
            tabsList.sort(Comparator.comparing(GuiTabItem::getId));
            for (GuiTabItem tabItem : tabsList) {
                try {
                    Object object = tabItem.getMethod().getDeclaringClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                    tabItem.getMethod().invoke(object, this.configTabs);
                }
                catch (Exception e) {
                    new ErrorDialog(hopGui.getShell(), "Error", "Hop was unable to invoke @GuiTab method " + tabItem.getMethod().getName() + " with the parent composite as argument", e);
                }
            }
            if (this.configTabs.getItemCount() > 0) {
                this.configTabs.setSelection(0);
            }
        }
        this.configTabs.layout();
    }

    public void showSystemVariablesTab() {
        for (CTabItem cTabItem : this.configTabs.getItems()) {
        }
    }

    @Override
    public boolean hasNavigationPreviousFile() {
        return false;
    }

    @Override
    public boolean hasNavigationNextFile() {
        return false;
    }

    @Override
    public Control getControl() {
        return this.composite;
    }

    @Override
    public boolean remove(IHopFileTypeHandler typeHandler) {
        return false;
    }

    @Override
    public List<TabItemHandler> getItems() {
        return null;
    }

    @Override
    public List<ISearchable> getSearchables() {
        return new ArrayList<ISearchable>();
    }

    @Override
    public void closeTab(CTabFolderEvent event, CTabItem tabItem) {
    }

    @Override
    public List<CTabItem> getTabsToRight(CTabItem selectedTabItem) {
        return TabClosable.super.getTabsToRight(selectedTabItem);
    }

    @Override
    public List<CTabItem> getTabsToLeft(CTabItem selectedTabItem) {
        return TabClosable.super.getTabsToLeft(selectedTabItem);
    }

    @Override
    public List<CTabItem> getOtherTabs(CTabItem selectedTabItem) {
        return TabClosable.super.getOtherTabs(selectedTabItem);
    }

    @Override
    public CTabFolder getTabFolder() {
        return this.configTabs;
    }
}

