/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty;

import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.util.Preconditions;

public class NettyPayload {
    @Nullable
    private final Buffer buffer;
    @Nullable
    private final Throwable error;
    private final int bufferIndex;
    private final int subpartitionId;
    private final int segmentId;

    private NettyPayload(@Nullable Buffer buffer, int bufferIndex, int subpartitionId, @Nullable Throwable error, int segmentId) {
        this.buffer = buffer;
        this.bufferIndex = bufferIndex;
        this.subpartitionId = subpartitionId;
        this.error = error;
        this.segmentId = segmentId;
    }

    public static NettyPayload newBuffer(Buffer buffer, int bufferIndex, int subpartitionId) {
        Preconditions.checkState((buffer != null && bufferIndex != -1 && subpartitionId != -1 ? 1 : 0) != 0);
        return new NettyPayload(buffer, bufferIndex, subpartitionId, null, -1);
    }

    public static NettyPayload newError(Throwable error) {
        return new NettyPayload(null, -1, -1, (Throwable)Preconditions.checkNotNull((Object)error), -1);
    }

    public static NettyPayload newSegment(int segmentId) {
        Preconditions.checkState((segmentId != -1 ? 1 : 0) != 0);
        return new NettyPayload(null, -1, -1, null, segmentId);
    }

    public Optional<Buffer> getBuffer() {
        return this.buffer != null ? Optional.of(this.buffer) : Optional.empty();
    }

    public Optional<Throwable> getError() {
        return this.error != null ? Optional.of(this.error) : Optional.empty();
    }

    public int getBufferIndex() {
        return this.bufferIndex;
    }

    public int getSubpartitionId() {
        return this.subpartitionId;
    }

    public int getSegmentId() {
        return this.segmentId;
    }
}

