/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.Time;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class Log4jWarningErrorMetricsAppender
extends AppenderSkeleton {
    public static final String LOG_METRICS_APPENDER = "RM_LOG_METRICS_APPENDER";
    static final int MAX_MESSAGE_SIZE = 2048;
    Map<String, SortedMap<Long, Integer>> errors;
    Map<String, SortedMap<Long, Integer>> warnings;
    SortedMap<Long, Integer> errorsTimestampCount;
    SortedMap<Long, Integer> warningsTimestampCount;
    SortedSet<PurgeElement> errorsPurgeInformation;
    SortedSet<PurgeElement> warningsPurgeInformation;
    Timer cleanupTimer;
    long cleanupInterval;
    long messageAgeLimitSeconds;
    int maxUniqueMessages;
    final Object lock = new Object();

    public Log4jWarningErrorMetricsAppender() {
        this(300, 86400L, 250);
    }

    public Log4jWarningErrorMetricsAppender(int cleanupIntervalSeconds, long messageAgeLimitSeconds, int maxUniqueMessages) {
        this.errors = new HashMap<String, SortedMap<Long, Integer>>();
        this.warnings = new HashMap<String, SortedMap<Long, Integer>>();
        this.errorsTimestampCount = new TreeMap<Long, Integer>();
        this.warningsTimestampCount = new TreeMap<Long, Integer>();
        this.errorsPurgeInformation = new TreeSet<PurgeElement>();
        this.warningsPurgeInformation = new TreeSet<PurgeElement>();
        this.cleanupTimer = new Timer();
        this.cleanupInterval = cleanupIntervalSeconds * 1000;
        this.cleanupTimer.schedule((TimerTask)new ErrorAndWarningsCleanup(), this.cleanupInterval);
        this.messageAgeLimitSeconds = messageAgeLimitSeconds;
        this.maxUniqueMessages = maxUniqueMessages;
        this.setName(LOG_METRICS_APPENDER);
        this.setThreshold((Priority)Level.WARN);
    }

    protected void append(LoggingEvent event) {
        int level;
        String message = event.getRenderedMessage();
        String[] throwableStr = event.getThrowableStrRep();
        if (throwableStr != null) {
            message = message + "\n" + org.apache.hadoop.util.StringUtils.join((CharSequence)"\n", (String[])throwableStr);
            message = StringUtils.left((String)message, (int)2048);
        }
        if ((level = event.getLevel().toInt()) == 30000 || level == 40000) {
            SortedSet<PurgeElement> purgeInformation;
            SortedMap<Long, Integer> timestampsCount;
            Map<String, SortedMap<Long, Integer>> map;
            Long eventTimeSeconds = event.getTimeStamp() / 1000L;
            if (level == 30000) {
                map = this.warnings;
                timestampsCount = this.warningsTimestampCount;
                purgeInformation = this.warningsPurgeInformation;
            } else {
                map = this.errors;
                timestampsCount = this.errorsTimestampCount;
                purgeInformation = this.errorsPurgeInformation;
            }
            this.updateMessageDetails(message, eventTimeSeconds, map, timestampsCount, purgeInformation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMessageDetails(String message, Long eventTimeSeconds, Map<String, SortedMap<Long, Integer>> map, SortedMap<Long, Integer> timestampsCount, SortedSet<PurgeElement> purgeInformation) {
        Object object = this.lock;
        synchronized (object) {
            if (map.containsKey(message)) {
                SortedMap<Long, Integer> tmp = map.get(message);
                Long lastMessageTime = tmp.lastKey();
                int value = 1;
                if (tmp.containsKey(eventTimeSeconds)) {
                    value = (Integer)tmp.get(eventTimeSeconds) + 1;
                }
                tmp.put(eventTimeSeconds, value);
                purgeInformation.remove(new PurgeElement(message, lastMessageTime));
            } else {
                TreeMap<Long, Integer> value = new TreeMap<Long, Integer>();
                value.put(eventTimeSeconds, 1);
                map.put(message, value);
                if (map.size() > this.maxUniqueMessages * 2) {
                    this.cleanupTimer.cancel();
                    this.cleanupTimer = new Timer();
                    this.cleanupTimer.schedule((TimerTask)new ErrorAndWarningsCleanup(), 0L);
                }
            }
            purgeInformation.add(new PurgeElement(message, eventTimeSeconds));
            int newValue = 1;
            if (timestampsCount.containsKey(eventTimeSeconds)) {
                newValue = (Integer)timestampsCount.get(eventTimeSeconds) + 1;
            }
            timestampsCount.put(eventTimeSeconds, newValue);
        }
    }

    public void close() {
        this.cleanupTimer.cancel();
    }

    public boolean requiresLayout() {
        return false;
    }

    public List<Integer> getErrorCounts(List<Long> cutoffs) {
        return this.getCounts(this.errorsTimestampCount, cutoffs);
    }

    public List<Integer> getWarningCounts(List<Long> cutoffs) {
        return this.getCounts(this.warningsTimestampCount, cutoffs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Integer> getCounts(SortedMap<Long, Integer> map, List<Long> cutoffs) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        Long largestCutoff = Collections.min(cutoffs);
        for (int i = 0; i < cutoffs.size(); ++i) {
            ret.add(0);
        }
        Object object = this.lock;
        synchronized (object) {
            SortedMap<Long, Integer> submap = map.tailMap(largestCutoff);
            for (Map.Entry entry : submap.entrySet()) {
                for (int i = 0; i < cutoffs.size(); ++i) {
                    if ((Long)entry.getKey() < cutoffs.get(i)) continue;
                    int tmp = (Integer)ret.get(i);
                    ret.set(i, tmp + (Integer)entry.getValue());
                }
            }
        }
        return ret;
    }

    public List<Map<String, Element>> getErrorMessagesAndCounts(List<Long> cutoffs) {
        return this.getElementsAndCounts(this.errors, cutoffs, this.errorsPurgeInformation);
    }

    public List<Map<String, Element>> getWarningMessagesAndCounts(List<Long> cutoffs) {
        return this.getElementsAndCounts(this.warnings, cutoffs, this.warningsPurgeInformation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Element>> getElementsAndCounts(Map<String, SortedMap<Long, Integer>> map, List<Long> cutoffs, SortedSet<PurgeElement> purgeInformation) {
        if (purgeInformation.size() > this.maxUniqueMessages) {
            ErrorAndWarningsCleanup cleanup = new ErrorAndWarningsCleanup();
            long cutoff = Time.now() - this.messageAgeLimitSeconds * 1000L;
            cleanup.cleanupMessages(map, purgeInformation, cutoff /= 1000L, this.maxUniqueMessages);
        }
        ArrayList<Map<String, Element>> ret = new ArrayList<Map<String, Element>>(cutoffs.size());
        for (int i = 0; i < cutoffs.size(); ++i) {
            ret.add(new HashMap());
        }
        Object object = this.lock;
        synchronized (object) {
            for (Map.Entry<String, SortedMap<Long, Integer>> element : map.entrySet()) {
                for (int i = 0; i < cutoffs.size(); ++i) {
                    Map retMap = (Map)ret.get(i);
                    SortedMap<Long, Integer> qualifyingTimes = element.getValue().tailMap(cutoffs.get(i));
                    long count = 0L;
                    for (Map.Entry<Long, Integer> entry : qualifyingTimes.entrySet()) {
                        count += (long)entry.getValue().intValue();
                    }
                    if (qualifyingTimes.isEmpty()) continue;
                    retMap.put(element.getKey(), new Element(count, qualifyingTimes.lastKey()));
                }
            }
        }
        return ret;
    }

    public long getCleanupInterval() {
        return this.cleanupInterval;
    }

    public void setCleanupInterval(long cleanupInterval) {
        this.cleanupInterval = cleanupInterval;
    }

    public long getMessageAgeLimitSeconds() {
        return this.messageAgeLimitSeconds;
    }

    public void setMessageAgeLimitSeconds(long messageAgeLimitSeconds) {
        this.messageAgeLimitSeconds = messageAgeLimitSeconds;
    }

    public int getMaxUniqueMessages() {
        return this.maxUniqueMessages;
    }

    public void setMaxUniqueMessages(int maxUniqueMessages) {
        this.maxUniqueMessages = maxUniqueMessages;
    }

    public static Log4jWarningErrorMetricsAppender findAppender() {
        Enumeration appenders = Logger.getRootLogger().getAllAppenders();
        while (appenders.hasMoreElements()) {
            Object obj = appenders.nextElement();
            if (!(obj instanceof Log4jWarningErrorMetricsAppender)) continue;
            return (Log4jWarningErrorMetricsAppender)((Object)obj);
        }
        return null;
    }

    class ErrorAndWarningsCleanup
    extends TimerTask {
        ErrorAndWarningsCleanup() {
        }

        @Override
        public void run() {
            long cutoff = Time.now() - Log4jWarningErrorMetricsAppender.this.messageAgeLimitSeconds * 1000L;
            this.cleanupMessages(Log4jWarningErrorMetricsAppender.this.errors, Log4jWarningErrorMetricsAppender.this.errorsPurgeInformation, cutoff /= 1000L, Log4jWarningErrorMetricsAppender.this.maxUniqueMessages);
            this.cleanupMessages(Log4jWarningErrorMetricsAppender.this.warnings, Log4jWarningErrorMetricsAppender.this.warningsPurgeInformation, cutoff, Log4jWarningErrorMetricsAppender.this.maxUniqueMessages);
            this.cleanupCounts(Log4jWarningErrorMetricsAppender.this.errorsTimestampCount, cutoff);
            this.cleanupCounts(Log4jWarningErrorMetricsAppender.this.warningsTimestampCount, cutoff);
            try {
                Log4jWarningErrorMetricsAppender.this.cleanupTimer.schedule((TimerTask)new ErrorAndWarningsCleanup(), Log4jWarningErrorMetricsAppender.this.cleanupInterval);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cleanupMessages(Map<String, SortedMap<Long, Integer>> map, SortedSet<PurgeElement> purgeInformation, long cutoff, int mapTargetSize) {
            PurgeElement el = new PurgeElement("", cutoff);
            Object object = Log4jWarningErrorMetricsAppender.this.lock;
            synchronized (object) {
                SortedSet<PurgeElement> removeSet = purgeInformation.headSet(el);
                Iterator it = removeSet.iterator();
                while (it.hasNext()) {
                    PurgeElement p = (PurgeElement)it.next();
                    map.remove(p.message);
                    it.remove();
                }
                if (purgeInformation.size() > mapTargetSize) {
                    Object[] array = purgeInformation.toArray();
                    int cutoffIndex = purgeInformation.size() - mapTargetSize;
                    for (int i = 0; i < cutoffIndex; ++i) {
                        PurgeElement p = (PurgeElement)array[i];
                        map.remove(p.message);
                        purgeInformation.remove(p);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cleanupCounts(SortedMap<Long, Integer> map, long cutoff) {
            Object object = Log4jWarningErrorMetricsAppender.this.lock;
            synchronized (object) {
                Iterator<Map.Entry<Long, Integer>> it = map.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Long, Integer> element = it.next();
                    if (element.getKey() >= cutoff) continue;
                    it.remove();
                }
            }
        }
    }

    static class PurgeElement
    implements Comparable<PurgeElement> {
        String message;
        Long timestamp;

        PurgeElement(String message, Long timestamp) {
            this.message = message;
            this.timestamp = timestamp;
        }

        @Override
        public int compareTo(PurgeElement e) {
            if (e == null) {
                throw new NullPointerException("Null element passed to compareTo");
            }
            int ret = this.timestamp.compareTo(e.timestamp);
            if (ret != 0) {
                return ret;
            }
            return this.message.compareTo(e.message);
        }

        public boolean equals(Object e) {
            if (e == null || !(e instanceof PurgeElement)) {
                return false;
            }
            if (e == this) {
                return true;
            }
            PurgeElement el = (PurgeElement)e;
            return this.message.equals(el.message) && this.timestamp.equals(el.timestamp);
        }

        public int hashCode() {
            return this.timestamp.hashCode();
        }
    }

    public static class Element {
        public Long count;
        public Long timestampSeconds;

        Element(Long count, Long timestampSeconds) {
            this.count = count;
            this.timestampSeconds = timestampSeconds;
        }
    }
}

