/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.lab.jvm.attach;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import org.gridkit.lab.jvm.attach.JavaProcessDetails;

public interface JavaProcessMatcher {
    public boolean evaluate(JavaProcessDetails var1);

    public static class Union
    implements JavaProcessMatcher,
    Serializable {
        private static final long serialVersionUID = 20121112L;
        private final JavaProcessMatcher[] matchers;

        public Union(JavaProcessMatcher ... matchers) {
            this.matchers = matchers;
            if (matchers.length == 0) {
                throw new IllegalArgumentException("Matcher list is empty");
            }
        }

        public Union(Collection<JavaProcessMatcher> matchers) {
            this(matchers.toArray(new JavaProcessMatcher[0]));
        }

        @Override
        public boolean evaluate(JavaProcessDetails details) {
            for (JavaProcessMatcher matcher : this.matchers) {
                if (!matcher.evaluate(details)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return "UNION" + Arrays.asList(this.matchers);
        }
    }
}

