/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class MagicReader {
    private static final String MAGIC_APHLABET = "-_.0123456789ABCDEFHIJKLMNOPQRSTUVWXYZabcdefhijklmnopqrstuvwxyz";

    public static byte[] readMagic(InputStream is) throws IOException {
        int c;
        byte[] buf = new byte[32];
        int n = 0;
        while (true) {
            if ((c = is.read()) < 0) {
                throw new EOFException("Cannot read magic");
            }
            if (n >= buf.length) {
                throw new IOException("Cannot read magic");
            }
            if (c == 32) break;
            if (MAGIC_APHLABET.indexOf(c) < 0) {
                throw new IOException("Invalid magic");
            }
            buf[n] = (byte)c;
            ++n;
        }
        buf[n] = (byte)c;
        return Arrays.copyOf(buf, ++n);
    }
}

