/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.snowflake.client.core.OpaqueContextDTO;
import net.snowflake.client.core.QueryContextDTO;
import net.snowflake.client.core.QueryContextEntryDTO;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class QueryContextCache {
    private final int capacity;
    private final HashMap<Long, QueryContextElement> idMap;
    private final TreeSet<QueryContextElement> treeSet;
    private final HashMap<Long, QueryContextElement> priorityMap;
    private final HashMap<Long, QueryContextElement> newPriorityMap;
    private static final SFLogger logger = SFLoggerFactory.getLogger(QueryContextCache.class);
    private static ObjectMapper jsonObjectMapper = new ObjectMapper();

    public QueryContextCache(int capacity) {
        this.capacity = capacity;
        this.idMap = new HashMap();
        this.priorityMap = new HashMap();
        this.newPriorityMap = new HashMap();
        this.treeSet = new TreeSet<QueryContextElement>(Comparator.comparingLong(QueryContextElement::getPriority).thenComparingLong(QueryContextElement::getId).thenComparingLong(QueryContextElement::getReadTimestamp));
    }

    void merge(long id, long readTimestamp, long priority, String context) {
        if (this.idMap.containsKey(id)) {
            QueryContextElement qce = this.idMap.get(id);
            if (readTimestamp > qce.readTimestamp) {
                if (qce.priority == priority) {
                    qce.readTimestamp = readTimestamp;
                    qce.context = context;
                } else {
                    QueryContextElement newQCE = new QueryContextElement(id, readTimestamp, priority, context);
                    this.replaceQCE(qce, newQCE);
                }
            } else if (readTimestamp == qce.readTimestamp && qce.priority != priority) {
                QueryContextElement newQCE = new QueryContextElement(id, readTimestamp, priority, context);
                this.replaceQCE(qce, newQCE);
            }
        } else if (this.priorityMap.containsKey(priority)) {
            QueryContextElement qce = this.priorityMap.get(priority);
            QueryContextElement newQCE = new QueryContextElement(id, readTimestamp, priority, context);
            this.replaceQCE(qce, newQCE);
        } else {
            QueryContextElement newQCE = new QueryContextElement(id, readTimestamp, priority, context);
            this.addQCE(newQCE);
        }
    }

    void syncPriorityMap() {
        logger.debug("syncPriorityMap called priorityMap size: {}, newPrioirtyMap size: {}", this.priorityMap.size(), this.newPriorityMap.size());
        for (Map.Entry<Long, QueryContextElement> entry : this.newPriorityMap.entrySet()) {
            this.priorityMap.put(entry.getKey(), entry.getValue());
        }
        this.newPriorityMap.clear();
    }

    void checkCacheCapacity() {
        logger.debug("checkCacheCapacity() called. treeSet size: {} cache capacity: {}", this.treeSet.size(), this.capacity);
        if (this.treeSet.size() > this.capacity) {
            while (this.treeSet.size() > this.capacity) {
                QueryContextElement qce = this.treeSet.last();
                this.removeQCE(qce);
            }
        }
        logger.debug("checkCacheCapacity() returns. treeSet size: {} cache capacity: {}", this.treeSet.size(), this.capacity);
    }

    public void clearCache() {
        logger.trace("clearCache() called", new Object[0]);
        this.idMap.clear();
        this.priorityMap.clear();
        this.treeSet.clear();
        logger.trace("clearCache() returns. Number of entries in cache now: {}", this.treeSet.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deserializeQueryContextJson(String data) {
        QueryContextCache queryContextCache = this;
        synchronized (queryContextCache) {
            this.logCacheEntries();
            if (data == null || data.length() == 0) {
                this.clearCache();
                return;
            }
            try {
                JsonNode rootNode = jsonObjectMapper.readTree(data);
                JsonNode entriesNode = rootNode.path("entries");
                if (entriesNode != null && entriesNode.isArray()) {
                    for (JsonNode entryNode : entriesNode) {
                        QueryContextElement entry = QueryContextCache.deserializeQueryContextElement(entryNode);
                        if (entry != null) {
                            this.merge(entry.id, entry.readTimestamp, entry.priority, entry.context);
                            continue;
                        }
                        logger.warn("deserializeQueryContextJson: deserializeQueryContextElement meets mismatch field type. Clear the QueryContextCache.", new Object[0]);
                        this.clearCache();
                        return;
                    }
                    this.syncPriorityMap();
                }
            }
            catch (Exception e) {
                logger.debug("deserializeQueryContextJson: Exception: {}", e.getMessage());
                this.clearCache();
            }
            this.checkCacheCapacity();
            this.logCacheEntries();
        }
    }

    private static QueryContextElement deserializeQueryContextElement(JsonNode node) throws IOException {
        QueryContextElement entry = new QueryContextElement();
        JsonNode idNode = node.path("id");
        if (!idNode.isNumber()) {
            logger.warn("deserializeQueryContextElement: `id` field is not Number type", new Object[0]);
            return null;
        }
        entry.setId(idNode.asLong());
        JsonNode timestampNode = node.path("timestamp");
        if (!timestampNode.isNumber()) {
            logger.warn("deserializeQueryContextElement: `timestamp` field is not Long type", new Object[0]);
            return null;
        }
        entry.setReadTimestamp(timestampNode.asLong());
        JsonNode priorityNode = node.path("priority");
        if (!priorityNode.isNumber()) {
            logger.warn("deserializeQueryContextElement: `priority` field is not Long type", new Object[0]);
            return null;
        }
        entry.setPriority(priorityNode.asLong());
        JsonNode contextNode = node.path("context");
        if (contextNode.isTextual()) {
            String contextBytes = contextNode.asText();
            entry.setContext(contextBytes);
        } else if (contextNode.isEmpty()) {
            logger.debug("deserializeQueryContextElement `context` field is empty", new Object[0]);
        } else {
            logger.warn("deserializeQueryContextElement: `context` field is not String type", new Object[0]);
            return null;
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deserializeQueryContextDTO(QueryContextDTO queryContextDTO) {
        QueryContextCache queryContextCache = this;
        synchronized (queryContextCache) {
            this.logCacheEntries();
            if (queryContextDTO == null) {
                this.clearCache();
                this.logCacheEntries();
                return;
            }
            try {
                List<QueryContextEntryDTO> entries = queryContextDTO.getEntries();
                if (entries != null) {
                    for (QueryContextEntryDTO entryDTO : entries) {
                        QueryContextElement entry = QueryContextCache.deserializeQueryContextElementDTO(entryDTO);
                        this.merge(entry.id, entry.readTimestamp, entry.priority, entry.context);
                        this.logCacheEntries();
                    }
                }
                this.syncPriorityMap();
            }
            catch (Exception e) {
                logger.debug("deserializeQueryContextDTO: Exception: {}", e.getMessage());
                this.clearCache();
            }
            this.checkCacheCapacity();
            this.logCacheEntries();
        }
    }

    private static QueryContextElement deserializeQueryContextElementDTO(QueryContextEntryDTO entryDTO) throws IOException {
        QueryContextElement entry = new QueryContextElement(entryDTO.getId(), entryDTO.getTimestamp(), entryDTO.getPriority(), entryDTO.getContext().getBase64Data());
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryContextDTO serializeQueryContextDTO() {
        QueryContextCache queryContextCache = this;
        synchronized (queryContextCache) {
            this.logCacheEntries();
            TreeSet<QueryContextElement> elements = this.getElements();
            if (elements.size() == 0) {
                return null;
            }
            try {
                QueryContextDTO queryContextDTO = new QueryContextDTO();
                ArrayList<QueryContextEntryDTO> entries = new ArrayList<QueryContextEntryDTO>();
                for (QueryContextElement elem : elements) {
                    QueryContextEntryDTO queryContextElementDTO = this.serializeQueryContextEntryDTO(elem);
                    entries.add(queryContextElementDTO);
                }
                queryContextDTO.setEntries(entries);
                return queryContextDTO;
            }
            catch (Exception e) {
                logger.debug("serializeQueryContextDTO(): Exception: {}", e.getMessage());
                return null;
            }
        }
    }

    private QueryContextEntryDTO serializeQueryContextEntryDTO(QueryContextElement entry) throws IOException {
        QueryContextEntryDTO entryDTO = new QueryContextEntryDTO(entry.getId(), entry.getReadTimestamp(), entry.getPriority(), new OpaqueContextDTO(entry.getContext()));
        return entryDTO;
    }

    private static QueryContextElement createElement(long id, long timestamp, long priority, String opaqueContext) {
        return new QueryContextElement(id, timestamp, priority, opaqueContext);
    }

    private void addQCE(QueryContextElement qce) {
        this.idMap.put(qce.id, qce);
        this.priorityMap.put(qce.priority, qce);
        this.treeSet.add(qce);
    }

    private void removeQCE(QueryContextElement qce) {
        this.treeSet.remove(qce);
        this.priorityMap.remove(qce.priority);
        this.idMap.remove(qce.id);
    }

    private void replaceQCE(QueryContextElement oldQCE, QueryContextElement newQCE) {
        this.removeQCE(oldQCE);
        this.addQCE(newQCE);
    }

    private TreeSet<QueryContextElement> getElements() {
        return this.treeSet;
    }

    int getSize() {
        return this.treeSet.size();
    }

    void getElements(long[] ids, long[] readTimestamps, long[] priorities, String[] contexts) {
        TreeSet<QueryContextElement> elems = this.getElements();
        int i = 0;
        for (QueryContextElement elem : elems) {
            ids[i] = elem.id;
            readTimestamps[i] = elem.readTimestamp;
            priorities[i] = elem.priority;
            contexts[i] = elem.context;
            ++i;
        }
    }

    void logCacheEntries() {
        if (logger.isDebugEnabled()) {
            TreeSet<QueryContextElement> elements = this.getElements();
            for (QueryContextElement elem : elements) {
                logger.debug(" Cache Entry: id: {} readTimestamp: {} priority: {}", elem.id, elem.readTimestamp, elem.priority);
            }
        }
    }

    private static class QueryContextElement
    implements Comparable<QueryContextElement> {
        long id;
        long readTimestamp;
        long priority;
        String context;

        public QueryContextElement() {
        }

        public QueryContextElement(long id, long readTimestamp, long priority, String context) {
            this.id = id;
            this.readTimestamp = readTimestamp;
            this.priority = priority;
            this.context = context;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof QueryContextElement)) {
                return super.equals(obj);
            }
            QueryContextElement other = (QueryContextElement)obj;
            return this.id == other.id && this.readTimestamp == other.readTimestamp && this.priority == other.priority && this.context.equals(other.context);
        }

        public int hashCode() {
            int hash = 31;
            hash = hash * 31 + (int)this.id;
            hash += hash * 31 + (int)this.readTimestamp;
            hash += hash * 31 + (int)this.priority;
            hash += hash * 31 + this.context.hashCode();
            return hash;
        }

        @Override
        public int compareTo(QueryContextElement obj) {
            return this.priority == obj.priority ? 0 : (this.priority - obj.priority < 0L ? -1 : 1);
        }

        public void setId(long id) {
            this.id = id;
        }

        public void setPriority(long priority) {
            this.priority = priority;
        }

        public void setContext(String context) {
            this.context = context;
        }

        public void setReadTimestamp(long readTimestamp) {
            this.readTimestamp = readTimestamp;
        }

        public long getId() {
            return this.id;
        }

        public long getReadTimestamp() {
            return this.readTimestamp;
        }

        public long getPriority() {
            return this.priority;
        }

        public String getContext() {
            return this.context;
        }
    }
}

