/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.TimeZone;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.AbstractArrowVectorConverter;
import net.snowflake.client.core.arrow.ArrowResultUtil;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeDateWithTimezone;
import net.snowflake.client.jdbc.SnowflakeTimeWithTimezone;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BigIntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.IntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.StructVector;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFTimestamp;

public class ThreeFieldStructToTimestampTZConverter
extends AbstractArrowVectorConverter {
    private StructVector structVector;
    private BigIntVector epochs;
    private IntVector fractions;
    private IntVector timeZoneIndices;
    private TimeZone timeZone = TimeZone.getTimeZone("UTC");

    public ThreeFieldStructToTimestampTZConverter(ValueVector fieldVector, int columnIndex, DataConversionContext context) {
        super(SnowflakeType.TIMESTAMP_LTZ.name(), fieldVector, columnIndex, context);
        this.structVector = (StructVector)fieldVector;
        this.epochs = this.structVector.getChild("epoch", BigIntVector.class);
        this.fractions = this.structVector.getChild("fraction", IntVector.class);
        this.timeZoneIndices = this.structVector.getChild("timezone", IntVector.class);
    }

    @Override
    public boolean isNull(int index) {
        return this.structVector.isNull(index) || this.epochs.isNull(index) || this.fractions.isNull(index) || this.timeZoneIndices.isNull(index);
    }

    @Override
    public String toString(int index) throws SFException {
        if (this.context.getTimestampTZFormatter() == null) {
            throw new SFException(ErrorCode.INTERNAL_ERROR, "missing timestamp TZ formatter");
        }
        try {
            Timestamp ts = this.isNull(index) ? null : this.getTimestamp(index, TimeZone.getDefault(), true);
            return ts == null ? null : this.context.getTimestampTZFormatter().format(ts, this.timeZone, this.context.getScale(this.columnIndex));
        }
        catch (AbstractArrowVectorConverter.TimestampOperationNotAvailableException e) {
            return e.getSecsSinceEpoch().toPlainString();
        }
    }

    @Override
    public byte[] toBytes(int index) throws SFException {
        if (this.isNull(index)) {
            return null;
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "byteArray", this.toString(index));
    }

    @Override
    public Object toObject(int index) throws SFException {
        return this.toTimestamp(index, TimeZone.getDefault());
    }

    @Override
    public Timestamp toTimestamp(int index, TimeZone tz) throws SFException {
        return this.isNull(index) ? null : this.getTimestamp(index, tz, false);
    }

    private Timestamp getTimestamp(int index, TimeZone tz, boolean fromToString) throws SFException {
        long epoch = this.epochs.getDataBuffer().getLong(index * 8);
        int fraction = this.fractions.getDataBuffer().getInt(index * 4);
        int timeZoneIndex = this.timeZoneIndices.getDataBuffer().getInt(index * 4);
        this.timeZone = ThreeFieldStructToTimestampTZConverter.convertFromTimeZoneIndex(timeZoneIndex, this.context.getResultVersion());
        return ThreeFieldStructToTimestampTZConverter.getTimestamp(epoch, fraction, timeZoneIndex, this.context.getResultVersion(), this.useSessionTimezone, fromToString);
    }

    @Override
    public Date toDate(int index, TimeZone tz, boolean dateFormat) throws SFException {
        if (this.isNull(index)) {
            return null;
        }
        Timestamp ts = this.getTimestamp(index, TimeZone.getDefault(), false);
        return ts == null ? null : new SnowflakeDateWithTimezone(ts.getTime(), this.timeZone, this.useSessionTimezone);
    }

    @Override
    public Time toTime(int index) throws SFException {
        Timestamp ts = this.toTimestamp(index, TimeZone.getDefault());
        return ts == null ? null : new SnowflakeTimeWithTimezone(ts, this.timeZone, this.useSessionTimezone);
    }

    @Override
    public boolean toBoolean(int index) throws SFException {
        if (this.isNull(index)) {
            return false;
        }
        Timestamp val = this.toTimestamp(index, TimeZone.getDefault());
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "boolean", val);
    }

    @Override
    public short toShort(int rowIndex) throws SFException {
        if (this.isNull(rowIndex)) {
            return 0;
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "short", "");
    }

    public static Timestamp getTimestamp(long epoch, int fraction, int timeZoneIndex, long resultVersion, boolean useSessionTimezone, boolean fromToString) throws SFException {
        if (ArrowResultUtil.isTimestampOverflow(epoch)) {
            if (fromToString) {
                throw new AbstractArrowVectorConverter.TimestampOperationNotAvailableException(epoch, fraction);
            }
            return null;
        }
        TimeZone timeZone = ThreeFieldStructToTimestampTZConverter.convertFromTimeZoneIndex(timeZoneIndex, resultVersion);
        Timestamp ts = ArrowResultUtil.createTimestamp(epoch, fraction, timeZone, useSessionTimezone);
        return ResultUtil.adjustTimestamp(ts);
    }

    private static TimeZone convertFromTimeZoneIndex(int timeZoneIndex, long resultVersion) {
        if (resultVersion > 0L) {
            return SFTimestamp.convertTimezoneIndexToTimeZone(timeZoneIndex);
        }
        return TimeZone.getTimeZone("UTC");
    }
}

