/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl;

import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.BaseWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.BigIntWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.BitWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.Float4Writer;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.Float8Writer;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.IntWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.VarBinaryWriter;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.writer.VarCharWriter;

public class StructOrListWriterImpl
implements BaseWriter.StructOrListWriter {
    public final BaseWriter.StructWriter struct;
    public final BaseWriter.ListWriter list;

    public StructOrListWriterImpl(BaseWriter.StructWriter writer) {
        this.struct = writer;
        this.list = null;
    }

    public StructOrListWriterImpl(BaseWriter.ListWriter writer) {
        this.struct = null;
        this.list = writer;
    }

    @Override
    public void start() {
        if (this.struct != null) {
            this.struct.start();
        } else {
            this.list.startList();
        }
    }

    @Override
    public void end() {
        if (this.struct != null) {
            this.struct.end();
        } else {
            this.list.endList();
        }
    }

    @Override
    public BaseWriter.StructOrListWriter struct(String name) {
        assert (this.struct != null);
        return new StructOrListWriterImpl(this.struct.struct(name));
    }

    @Override
    @Deprecated
    public BaseWriter.StructOrListWriter listoftstruct(String name) {
        return this.listOfStruct(name);
    }

    @Override
    public BaseWriter.StructOrListWriter listOfStruct(String name) {
        assert (this.list != null);
        return new StructOrListWriterImpl(this.list.struct());
    }

    @Override
    public BaseWriter.StructOrListWriter list(String name) {
        assert (this.struct != null);
        return new StructOrListWriterImpl(this.struct.list(name));
    }

    @Override
    public boolean isStructWriter() {
        return this.struct != null;
    }

    @Override
    public boolean isListWriter() {
        return this.list != null;
    }

    @Override
    public VarCharWriter varChar(String name) {
        return this.struct != null ? this.struct.varChar(name) : this.list.varChar();
    }

    @Override
    public IntWriter integer(String name) {
        return this.struct != null ? this.struct.integer(name) : this.list.integer();
    }

    @Override
    public BigIntWriter bigInt(String name) {
        return this.struct != null ? this.struct.bigInt(name) : this.list.bigInt();
    }

    @Override
    public Float4Writer float4(String name) {
        return this.struct != null ? this.struct.float4(name) : this.list.float4();
    }

    @Override
    public Float8Writer float8(String name) {
        return this.struct != null ? this.struct.float8(name) : this.list.float8();
    }

    @Override
    public BitWriter bit(String name) {
        return this.struct != null ? this.struct.bit(name) : this.list.bit();
    }

    @Override
    public VarBinaryWriter binary(String name) {
        return this.struct != null ? this.struct.varBinary(name) : this.list.varBinary();
    }
}

