/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.http.impl.io;

import net.snowflake.client.jdbc.internal.apache.http.HttpResponse;
import net.snowflake.client.jdbc.internal.apache.http.HttpResponseFactory;
import net.snowflake.client.jdbc.internal.apache.http.annotation.Contract;
import net.snowflake.client.jdbc.internal.apache.http.annotation.ThreadingBehavior;
import net.snowflake.client.jdbc.internal.apache.http.config.MessageConstraints;
import net.snowflake.client.jdbc.internal.apache.http.impl.DefaultHttpResponseFactory;
import net.snowflake.client.jdbc.internal.apache.http.impl.io.DefaultHttpResponseParser;
import net.snowflake.client.jdbc.internal.apache.http.io.HttpMessageParser;
import net.snowflake.client.jdbc.internal.apache.http.io.HttpMessageParserFactory;
import net.snowflake.client.jdbc.internal.apache.http.io.SessionInputBuffer;
import net.snowflake.client.jdbc.internal.apache.http.message.BasicLineParser;
import net.snowflake.client.jdbc.internal.apache.http.message.LineParser;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

