/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.snowflake.client.jdbc.internal.com.nimbusds.common.contenttype.ContentType;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.AbstractOptionallyAuthenticatedRequest;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ParseException;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.SerializeException;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.token.AccessToken;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.token.AccessTokenType;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.token.RefreshToken;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.token.Token;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.token.TypelessAccessToken;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.token.TypelessToken;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.StringUtils;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.URLUtils;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.Immutable;

@Immutable
public class TokenIntrospectionRequest
extends AbstractOptionallyAuthenticatedRequest {
    private final Token token;
    private final AccessToken clientAuthz;
    private final Map<String, List<String>> customParams;

    public TokenIntrospectionRequest(URI endpoint, Token token) {
        this(endpoint, token, null);
    }

    public TokenIntrospectionRequest(URI endpoint, Token token, Map<String, List<String>> customParams) {
        super(endpoint, null);
        this.token = Objects.requireNonNull(token);
        this.clientAuthz = null;
        this.customParams = customParams != null ? customParams : Collections.emptyMap();
    }

    public TokenIntrospectionRequest(URI endpoint, ClientAuthentication clientAuth, Token token) {
        this(endpoint, clientAuth, token, null);
    }

    public TokenIntrospectionRequest(URI endpoint, ClientAuthentication clientAuth, Token token, Map<String, List<String>> customParams) {
        super(endpoint, clientAuth);
        this.token = Objects.requireNonNull(token);
        this.clientAuthz = null;
        this.customParams = customParams != null ? customParams : Collections.emptyMap();
    }

    public TokenIntrospectionRequest(URI endpoint, AccessToken clientAuthz, Token token) {
        this(endpoint, clientAuthz, token, null);
    }

    public TokenIntrospectionRequest(URI endpoint, AccessToken clientAuthz, Token token, Map<String, List<String>> customParams) {
        super(endpoint, null);
        this.token = Objects.requireNonNull(token);
        this.clientAuthz = clientAuthz;
        this.customParams = customParams != null ? customParams : Collections.emptyMap();
    }

    public AccessToken getClientAuthorization() {
        return this.clientAuthz;
    }

    public Token getToken() {
        return this.token;
    }

    public Map<String, List<String>> getCustomParameters() {
        return this.customParams;
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.POST, this.getEndpointURI());
        httpRequest.setEntityContentType(ContentType.APPLICATION_URLENCODED);
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("token", Collections.singletonList(this.token.getValue()));
        if (this.token instanceof AccessToken) {
            params.put("token_type_hint", Collections.singletonList("access_token"));
        } else if (this.token instanceof RefreshToken) {
            params.put("token_type_hint", Collections.singletonList("refresh_token"));
        }
        params.putAll(this.customParams);
        httpRequest.setBody(URLUtils.serializeParameters(params));
        if (this.getClientAuthentication() != null) {
            this.getClientAuthentication().applyTo(httpRequest);
        }
        if (this.clientAuthz != null) {
            httpRequest.setAuthorization(this.clientAuthz.toAuthorizationHeader());
        }
        return httpRequest;
    }

    public static TokenIntrospectionRequest parse(HTTPRequest httpRequest) throws ParseException {
        httpRequest.ensureMethod(HTTPRequest.Method.POST);
        httpRequest.ensureEntityContentType(ContentType.APPLICATION_URLENCODED);
        Map params = httpRequest.getBodyAsFormParameters();
        String tokenValue = (String)MultivaluedMapUtils.removeAndReturnFirstValue(params, "token");
        if (StringUtils.isBlank(tokenValue)) {
            throw new ParseException("Missing required token parameter");
        }
        String tokenTypeHint = (String)MultivaluedMapUtils.removeAndReturnFirstValue(params, "token_type_hint");
        Token token = "access_token".equals(tokenTypeHint) ? new TypelessAccessToken(tokenValue) : ("refresh_token".equals(tokenTypeHint) ? new RefreshToken(tokenValue) : new TypelessToken(tokenValue));
        ClientAuthentication clientAuth = ClientAuthentication.parse(httpRequest);
        AccessToken clientAuthz = null;
        if (clientAuth == null && httpRequest.getAuthorization() != null) {
            clientAuthz = AccessToken.parse(httpRequest.getAuthorization(), AccessTokenType.BEARER);
        }
        URI uri = httpRequest.getURI();
        if (clientAuthz != null) {
            return new TokenIntrospectionRequest(uri, clientAuthz, token, (Map<String, List<String>>)params);
        }
        return new TokenIntrospectionRequest(uri, clientAuth, token, (Map<String, List<String>>)params);
    }
}

