/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.dpop;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JOSEException;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.util.Base64URL;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.JWTClaimsSet;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.id.JWTID;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.token.AccessToken;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.StringUtils;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.Nonce;

public final class DPoPUtils {
    @Deprecated
    public static JWTClaimsSet createJWTClaimsSet(JWTID jti, String htm, URI htu, Date iat, AccessToken accessToken) throws JOSEException {
        return DPoPUtils.createJWTClaimsSet(jti, htm, htu, iat, accessToken, null);
    }

    public static JWTClaimsSet createJWTClaimsSet(JWTID jti, String htm, URI htu, Date iat, AccessToken accessToken, Nonce nonce) throws JOSEException {
        if (StringUtils.isBlank(htm)) {
            throw new IllegalArgumentException("The HTTP method (htu) is required");
        }
        if (htu.getQuery() != null) {
            throw new IllegalArgumentException("The HTTP URI (htu) must not have a query");
        }
        if (htu.getFragment() != null) {
            throw new IllegalArgumentException("The HTTP URI (htu) must not have a fragment");
        }
        if (iat == null) {
            throw new IllegalArgumentException("The issue time (iat) is required");
        }
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder().jwtID(jti.getValue()).claim("htm", htm).claim("htu", htu.toString()).issueTime(iat);
        if (accessToken != null) {
            builder = builder.claim("ath", DPoPUtils.computeSHA256(accessToken).toString());
        }
        if (nonce != null) {
            builder = builder.claim("nonce", nonce.getValue());
        }
        return builder.build();
    }

    public static Base64URL computeSHA256(AccessToken accessToken) throws JOSEException {
        byte[] hash;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            hash = md.digest(accessToken.getValue().getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException e) {
            throw new JOSEException(e.getMessage(), e);
        }
        return Base64URL.encode(hash);
    }

    private DPoPUtils() {
    }
}

